package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NameServersUpdateState(
    code: Optional[zio.aws.lightsail.model.NameServersUpdateStateCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.NameServersUpdateState = {
    import NameServersUpdateState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.NameServersUpdateState
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.NameServersUpdateState.ReadOnly =
    zio.aws.lightsail.model.NameServersUpdateState.wrap(buildAwsValue())
}
object NameServersUpdateState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.NameServersUpdateState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.NameServersUpdateState =
      zio.aws.lightsail.model.NameServersUpdateState(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.lightsail.model.NameServersUpdateStateCode]
    def message: Optional[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.NameServersUpdateStateCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.NameServersUpdateState
  ) extends zio.aws.lightsail.model.NameServersUpdateState.ReadOnly {
    override val code
        : Optional[zio.aws.lightsail.model.NameServersUpdateStateCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.lightsail.model.NameServersUpdateStateCode.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.NameServersUpdateState
  ): zio.aws.lightsail.model.NameServersUpdateState.ReadOnly = new Wrapper(impl)
}
