package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PendingModifiedRelationalDatabaseValues(
    masterUserPassword: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    backupRetentionEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues = {
    import PendingModifiedRelationalDatabaseValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
      .builder()
      .optionallyWith(masterUserPassword.map(value => value: java.lang.String))(
        _.masterUserPassword
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        backupRetentionEnabled.map(value => value: java.lang.Boolean)
      )(_.backupRetentionEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly =
    zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues
      .wrap(buildAwsValue())
}
object PendingModifiedRelationalDatabaseValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues =
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues(
        masterUserPassword.map(value => value),
        engineVersion.map(value => value),
        backupRetentionEnabled.map(value => value)
      )
    def masterUserPassword: Optional[String]
    def engineVersion: Optional[String]
    def backupRetentionEnabled: Optional[Boolean]
    def getMasterUserPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getBackupRetentionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("backupRetentionEnabled", backupRetentionEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
  ) extends zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly {
    override val masterUserPassword: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUserPassword())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val backupRetentionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionEnabled())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues
  ): zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly =
    new Wrapper(impl)
}
