package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class RelationalDatabase(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    relationalDatabaseBlueprintId: Optional[NonEmptyString] = Optional.Absent,
    relationalDatabaseBundleId: Optional[NonEmptyString] = Optional.Absent,
    masterDatabaseName: Optional[String] = Optional.Absent,
    hardware: Optional[zio.aws.lightsail.model.RelationalDatabaseHardware] =
      Optional.Absent,
    state: Optional[NonEmptyString] = Optional.Absent,
    secondaryAvailabilityZone: Optional[String] = Optional.Absent,
    backupRetentionEnabled: Optional[Boolean] = Optional.Absent,
    pendingModifiedValues: Optional[
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues
    ] = Optional.Absent,
    engine: Optional[NonEmptyString] = Optional.Absent,
    engineVersion: Optional[NonEmptyString] = Optional.Absent,
    latestRestorableTime: Optional[IsoDate] = Optional.Absent,
    masterUsername: Optional[NonEmptyString] = Optional.Absent,
    parameterApplyStatus: Optional[NonEmptyString] = Optional.Absent,
    preferredBackupWindow: Optional[NonEmptyString] = Optional.Absent,
    preferredMaintenanceWindow: Optional[NonEmptyString] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    masterEndpoint: Optional[
      zio.aws.lightsail.model.RelationalDatabaseEndpoint
    ] = Optional.Absent,
    pendingMaintenanceActions: Optional[
      Iterable[zio.aws.lightsail.model.PendingMaintenanceAction]
    ] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabase = {
    import RelationalDatabase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabase
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        relationalDatabaseBlueprintId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.relationalDatabaseBlueprintId)
      .optionallyWith(
        relationalDatabaseBundleId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.relationalDatabaseBundleId)
      .optionallyWith(masterDatabaseName.map(value => value: java.lang.String))(
        _.masterDatabaseName
      )
      .optionallyWith(hardware.map(value => value.buildAwsValue()))(_.hardware)
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        secondaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.secondaryAvailabilityZone)
      .optionallyWith(
        backupRetentionEnabled.map(value => value: java.lang.Boolean)
      )(_.backupRetentionEnabled)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        latestRestorableTime.map(value => IsoDate.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        parameterApplyStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.parameterApplyStatus)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(masterEndpoint.map(value => value.buildAwsValue()))(
        _.masterEndpoint
      )
      .optionallyWith(
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActions)
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabase.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabase.wrap(buildAwsValue())
}
object RelationalDatabase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabase =
      zio.aws.lightsail.model.RelationalDatabase(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relationalDatabaseBlueprintId.map(value => value),
        relationalDatabaseBundleId.map(value => value),
        masterDatabaseName.map(value => value),
        hardware.map(value => value.asEditable),
        state.map(value => value),
        secondaryAvailabilityZone.map(value => value),
        backupRetentionEnabled.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        engine.map(value => value),
        engineVersion.map(value => value),
        latestRestorableTime.map(value => value),
        masterUsername.map(value => value),
        parameterApplyStatus.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        publiclyAccessible.map(value => value),
        masterEndpoint.map(value => value.asEditable),
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        caCertificateIdentifier.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def relationalDatabaseBlueprintId: Optional[NonEmptyString]
    def relationalDatabaseBundleId: Optional[NonEmptyString]
    def masterDatabaseName: Optional[String]
    def hardware
        : Optional[zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly]
    def state: Optional[NonEmptyString]
    def secondaryAvailabilityZone: Optional[String]
    def backupRetentionEnabled: Optional[Boolean]
    def pendingModifiedValues: Optional[
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly
    ]
    def engine: Optional[NonEmptyString]
    def engineVersion: Optional[NonEmptyString]
    def latestRestorableTime: Optional[IsoDate]
    def masterUsername: Optional[NonEmptyString]
    def parameterApplyStatus: Optional[NonEmptyString]
    def preferredBackupWindow: Optional[NonEmptyString]
    def preferredMaintenanceWindow: Optional[NonEmptyString]
    def publiclyAccessible: Optional[Boolean]
    def masterEndpoint
        : Optional[zio.aws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly]
    def pendingMaintenanceActions: Optional[
      List[zio.aws.lightsail.model.PendingMaintenanceAction.ReadOnly]
    ]
    def caCertificateIdentifier: Optional[String]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRelationalDatabaseBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "relationalDatabaseBlueprintId",
        relationalDatabaseBlueprintId
      )
    def getRelationalDatabaseBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "relationalDatabaseBundleId",
        relationalDatabaseBundleId
      )
    def getMasterDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterDatabaseName", masterDatabaseName)
    def getHardware: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly
    ] = AwsError.unwrapOptionField("hardware", hardware)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getSecondaryAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secondaryAvailabilityZone", secondaryAvailabilityZone)
    def getBackupRetentionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("backupRetentionEnabled", backupRetentionEnabled)
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLatestRestorableTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getParameterApplyStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatus)
    def getPreferredBackupWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getMasterEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("masterEndpoint", masterEndpoint)
    def getPendingMaintenanceActions: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.PendingMaintenanceAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActions",
      pendingMaintenanceActions
    )
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabase
  ) extends zio.aws.lightsail.model.RelationalDatabase.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val relationalDatabaseBlueprintId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationalDatabaseBlueprintId())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val relationalDatabaseBundleId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationalDatabaseBundleId())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val masterDatabaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterDatabaseName())
      .map(value => value: String)
    override val hardware: Optional[
      zio.aws.lightsail.model.RelationalDatabaseHardware.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hardware())
      .map(value =>
        zio.aws.lightsail.model.RelationalDatabaseHardware.wrap(value)
      )
    override val state: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val secondaryAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryAvailabilityZone())
        .map(value => value: String)
    override val backupRetentionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionEnabled())
        .map(value => value: Boolean)
    override val pendingModifiedValues: Optional[
      zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.lightsail.model.PendingModifiedRelationalDatabaseValues
          .wrap(value)
      )
    override val engine: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val engineVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val latestRestorableTime: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRestorableTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val masterUsername: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterUsername())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val parameterApplyStatus: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterApplyStatus())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val preferredBackupWindow: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredBackupWindow())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val preferredMaintenanceWindow: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val masterEndpoint: Optional[
      zio.aws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.masterEndpoint())
      .map(value =>
        zio.aws.lightsail.model.RelationalDatabaseEndpoint.wrap(value)
      )
    override val pendingMaintenanceActions: Optional[
      List[zio.aws.lightsail.model.PendingMaintenanceAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingMaintenanceActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.PendingMaintenanceAction.wrap(item)
        }.toList
      )
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabase
  ): zio.aws.lightsail.model.RelationalDatabase.ReadOnly = new Wrapper(impl)
}
