package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.IsoDate
import scala.jdk.CollectionConverters._
final case class ResetDistributionCacheResponse(
    status: Optional[String] = Optional.Absent,
    createTime: Optional[IsoDate] = Optional.Absent,
    operation: Optional[zio.aws.lightsail.model.Operation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse = {
    import ResetDistributionCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(createTime.map(value => IsoDate.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ResetDistributionCacheResponse.ReadOnly =
    zio.aws.lightsail.model.ResetDistributionCacheResponse.wrap(buildAwsValue())
}
object ResetDistributionCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ResetDistributionCacheResponse =
      zio.aws.lightsail.model.ResetDistributionCacheResponse(
        status.map(value => value),
        createTime.map(value => value),
        operation.map(value => value.asEditable)
      )
    def status: Optional[String]
    def createTime: Optional[IsoDate]
    def operation: Optional[zio.aws.lightsail.model.Operation.ReadOnly]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getCreateTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse
  ) extends zio.aws.lightsail.model.ResetDistributionCacheResponse.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val createTime: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val operation
        : Optional[zio.aws.lightsail.model.Operation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse
  ): zio.aws.lightsail.model.ResetDistributionCacheResponse.ReadOnly =
    new Wrapper(impl)
}
