package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait ResourceBucketAccess {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess
}
object ResourceBucketAccess {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess
  ): zio.aws.lightsail.model.ResourceBucketAccess = value match {
    case software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.ALLOW =>
      val r = allow
      r
    case software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.DENY =>
      val r = deny
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.ResourceBucketAccess {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess =
      software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.UNKNOWN_TO_SDK_VERSION
  }
  case object allow extends zio.aws.lightsail.model.ResourceBucketAccess {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess =
      software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.ALLOW
  }
  case object deny extends zio.aws.lightsail.model.ResourceBucketAccess {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess =
      software.amazon.awssdk.services.lightsail.model.ResourceBucketAccess.DENY
  }
}
