package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest = {
    import StartRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.StartRelationalDatabaseRequest.ReadOnly =
    zio.aws.lightsail.model.StartRelationalDatabaseRequest.wrap(buildAwsValue())
}
object StartRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.StartRelationalDatabaseRequest =
      zio.aws.lightsail.model
        .StartRelationalDatabaseRequest(relationalDatabaseName)
    def relationalDatabaseName: ResourceName
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest
  ) extends zio.aws.lightsail.model.StartRelationalDatabaseRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest
  ): zio.aws.lightsail.model.StartRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
