package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopInstanceRequest(
    instanceName: ResourceName,
    force: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StopInstanceRequest = {
    import StopInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StopInstanceRequest
      .builder()
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.StopInstanceRequest.ReadOnly =
    zio.aws.lightsail.model.StopInstanceRequest.wrap(buildAwsValue())
}
object StopInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StopInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.StopInstanceRequest =
      zio.aws.lightsail.model
        .StopInstanceRequest(instanceName, force.map(value => value))
    def instanceName: ResourceName
    def force: Optional[Boolean]
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StopInstanceRequest
  ) extends zio.aws.lightsail.model.StopInstanceRequest.ReadOnly {
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StopInstanceRequest
  ): zio.aws.lightsail.model.StopInstanceRequest.ReadOnly = new Wrapper(impl)
}
