package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDistributionBundleResponse(
    operation: Optional[zio.aws.lightsail.model.Operation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse = {
    import UpdateDistributionBundleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly =
    zio.aws.lightsail.model.UpdateDistributionBundleResponse
      .wrap(buildAwsValue())
}
object UpdateDistributionBundleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateDistributionBundleResponse =
      zio.aws.lightsail.model.UpdateDistributionBundleResponse(
        operation.map(value => value.asEditable)
      )
    def operation: Optional[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse
  ) extends zio.aws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly {
    override val operation
        : Optional[zio.aws.lightsail.model.Operation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse
  ): zio.aws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly =
    new Wrapper(impl)
}
