package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateInstanceMetadataOptionsResponse(
    operation: Optional[zio.aws.lightsail.model.Operation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsResponse = {
    import UpdateInstanceMetadataOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse.ReadOnly =
    zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse
      .wrap(buildAwsValue())
}
object UpdateInstanceMetadataOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse =
      zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse(
        operation.map(value => value.asEditable)
      )
    def operation: Optional[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsResponse
  ) extends zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse.ReadOnly {
    override val operation
        : Optional[zio.aws.lightsail.model.Operation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsResponse
  ): zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
