package zio.aws.lightsail
import zio.aws.lightsail.model.primitives.{
  Port,
  DomainName,
  Ipv6Address,
  ContainerName,
  DomainEntryOptionsKeys,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.lightsail.model.primitives.ContainerName.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AutoSnapshotDate extends Subtype[String]
    type AutoSnapshotDate =
      zio.aws.lightsail.model.primitives.AutoSnapshotDate.Type
    object Base64 extends Subtype[String]
    type Base64 = zio.aws.lightsail.model.primitives.Base64.Type
    object BucketAccessLogPrefix extends Subtype[String]
    type BucketAccessLogPrefix =
      zio.aws.lightsail.model.primitives.BucketAccessLogPrefix.Type
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.lightsail.model.primitives.BucketName.Type
    object CertificateName extends Subtype[String]
    type CertificateName =
      zio.aws.lightsail.model.primitives.CertificateName.Type
    object ContainerLabel extends Subtype[String]
    type ContainerLabel = zio.aws.lightsail.model.primitives.ContainerLabel.Type
    object ContainerName extends Subtype[String]
    type ContainerName = zio.aws.lightsail.model.primitives.ContainerName.Type
    object ContainerServiceName extends Subtype[String]
    type ContainerServiceName =
      zio.aws.lightsail.model.primitives.ContainerServiceName.Type
    object ContainerServiceScale extends Subtype[Int]
    type ContainerServiceScale =
      zio.aws.lightsail.model.primitives.ContainerServiceScale.Type
    object DomainEntryOptionsKeys extends Subtype[String]
    type DomainEntryOptionsKeys =
      zio.aws.lightsail.model.primitives.DomainEntryOptionsKeys.Type
    object DomainEntryType extends Subtype[String]
    type DomainEntryType =
      zio.aws.lightsail.model.primitives.DomainEntryType.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.lightsail.model.primitives.DomainName.Type
    object EligibleToRenew extends Subtype[String]
    type EligibleToRenew =
      zio.aws.lightsail.model.primitives.EligibleToRenew.Type
    object IAMAccessKeyId extends Subtype[String]
    type IAMAccessKeyId = zio.aws.lightsail.model.primitives.IAMAccessKeyId.Type
    object InUseResourceCount extends Subtype[Int]
    type InUseResourceCount =
      zio.aws.lightsail.model.primitives.InUseResourceCount.Type
    object IncludeCertificateDetails extends Subtype[Boolean]
    type IncludeCertificateDetails =
      zio.aws.lightsail.model.primitives.IncludeCertificateDetails.Type
    type Integer = Int
    object IpAddress extends Subtype[String]
    type IpAddress = zio.aws.lightsail.model.primitives.IpAddress.Type
    object Ipv6Address extends Subtype[String]
    type Ipv6Address = zio.aws.lightsail.model.primitives.Ipv6Address.Type
    object IsoDate extends Subtype[Instant]
    type IsoDate = zio.aws.lightsail.model.primitives.IsoDate.Type
    object IssuerCA extends Subtype[String]
    type IssuerCA = zio.aws.lightsail.model.primitives.IssuerCA.Type
    object KeyAlgorithm extends Subtype[String]
    type KeyAlgorithm = zio.aws.lightsail.model.primitives.KeyAlgorithm.Type
    object MetricPeriod extends Subtype[Int]
    type MetricPeriod = zio.aws.lightsail.model.primitives.MetricPeriod.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString = zio.aws.lightsail.model.primitives.NonEmptyString.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.lightsail.model.primitives.Port.Type
    object RenewalStatusReason extends Subtype[String]
    type RenewalStatusReason =
      zio.aws.lightsail.model.primitives.RenewalStatusReason.Type
    object RequestFailureReason extends Subtype[String]
    type RequestFailureReason =
      zio.aws.lightsail.model.primitives.RequestFailureReason.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.lightsail.model.primitives.ResourceArn.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.lightsail.model.primitives.ResourceName.Type
    object RevocationReason extends Subtype[String]
    type RevocationReason =
      zio.aws.lightsail.model.primitives.RevocationReason.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString =
      zio.aws.lightsail.model.primitives.SensitiveString.Type
    object SerialNumber extends Subtype[String]
    type SerialNumber = zio.aws.lightsail.model.primitives.SerialNumber.Type
    object StringMax256 extends Subtype[String]
    type StringMax256 = zio.aws.lightsail.model.primitives.StringMax256.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.lightsail.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.lightsail.model.primitives.TagValue.Type
    object TimeOfDay extends Subtype[String]
    type TimeOfDay = zio.aws.lightsail.model.primitives.TimeOfDay.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.lightsail.model.primitives.Timestamp.Type
  }
  type AccessKeyList = List[zio.aws.lightsail.model.AccessKey]
  type AccessReceiverList =
    List[zio.aws.lightsail.model.ResourceReceivingAccess]
  type AddOnList = List[zio.aws.lightsail.model.AddOn]
  type AddOnRequestList = List[zio.aws.lightsail.model.AddOnRequest]
  type AlarmsList = List[zio.aws.lightsail.model.Alarm]
  type AttachedDiskList = List[zio.aws.lightsail.model.AttachedDisk]
  type AttachedDiskMap =
    Map[ResourceName, Iterable[zio.aws.lightsail.model.DiskMap]]
  type AutoSnapshotDetailsList =
    List[zio.aws.lightsail.model.AutoSnapshotDetails]
  type AvailabilityZoneList = List[zio.aws.lightsail.model.AvailabilityZone]
  type BlueprintList = List[zio.aws.lightsail.model.Blueprint]
  type BucketBundleList = List[zio.aws.lightsail.model.BucketBundle]
  type BucketList = List[zio.aws.lightsail.model.Bucket]
  type BundleList = List[zio.aws.lightsail.model.Bundle]
  type CacheBehaviorList = List[zio.aws.lightsail.model.CacheBehaviorPerPath]
  type CertificateStatusList = List[zio.aws.lightsail.model.CertificateStatus]
  type CertificateSummaryList = List[zio.aws.lightsail.model.CertificateSummary]
  type CloudFormationStackRecordList =
    List[zio.aws.lightsail.model.CloudFormationStackRecord]
  type CloudFormationStackRecordSourceInfoList =
    List[zio.aws.lightsail.model.CloudFormationStackRecordSourceInfo]
  type ContactMethodsList = List[zio.aws.lightsail.model.ContactMethod]
  type ContactProtocolsList = List[zio.aws.lightsail.model.ContactProtocol]
  type ContainerImageList = List[zio.aws.lightsail.model.ContainerImage]
  type ContainerMap = Map[ContainerName, zio.aws.lightsail.model.Container]
  type ContainerServiceDeploymentList =
    List[zio.aws.lightsail.model.ContainerServiceDeployment]
  type ContainerServiceList = List[zio.aws.lightsail.model.ContainerService]
  type ContainerServiceLogEventList =
    List[zio.aws.lightsail.model.ContainerServiceLogEvent]
  type ContainerServiceMetadataEntry = Map[String, String]
  type ContainerServiceMetadataEntryList = List[Map[String, String]]
  type ContainerServicePowerList =
    List[zio.aws.lightsail.model.ContainerServicePower]
  type ContainerServicePublicDomains = Map[String, Iterable[String]]
  type ContainerServicePublicDomainsList = List[String]
  type DiskInfoList = List[zio.aws.lightsail.model.DiskInfo]
  type DiskList = List[zio.aws.lightsail.model.Disk]
  type DiskMapList = List[zio.aws.lightsail.model.DiskMap]
  type DiskSnapshotList = List[zio.aws.lightsail.model.DiskSnapshot]
  type DistributionBundleList = List[zio.aws.lightsail.model.DistributionBundle]
  type DistributionList = List[zio.aws.lightsail.model.LightsailDistribution]
  type DomainEntryList = List[zio.aws.lightsail.model.DomainEntry]
  type DomainEntryOptions = Map[DomainEntryOptionsKeys, String]
  type DomainList = List[zio.aws.lightsail.model.Domain]
  type DomainNameList = List[DomainName]
  type DomainValidationRecordList =
    List[zio.aws.lightsail.model.DomainValidationRecord]
  type Environment = Map[String, String]
  type ExportSnapshotRecordList =
    List[zio.aws.lightsail.model.ExportSnapshotRecord]
  type HeaderForwardList = List[zio.aws.lightsail.model.HeaderEnum]
  type HostKeysList = List[zio.aws.lightsail.model.HostKeyAttributes]
  type InstanceEntryList = List[zio.aws.lightsail.model.InstanceEntry]
  type InstanceHealthSummaryList =
    List[zio.aws.lightsail.model.InstanceHealthSummary]
  type InstanceList = List[zio.aws.lightsail.model.Instance]
  type InstancePlatformList = List[zio.aws.lightsail.model.InstancePlatform]
  type InstancePortInfoList = List[zio.aws.lightsail.model.InstancePortInfo]
  type InstancePortStateList = List[zio.aws.lightsail.model.InstancePortState]
  type InstanceSnapshotList = List[zio.aws.lightsail.model.InstanceSnapshot]
  type Ipv6AddressList = List[Ipv6Address]
  type KeyPairList = List[zio.aws.lightsail.model.KeyPair]
  type LoadBalancerConfigurationOptions =
    Map[zio.aws.lightsail.model.LoadBalancerAttributeName, String]
  type LoadBalancerList = List[zio.aws.lightsail.model.LoadBalancer]
  type LoadBalancerTlsCertificateDomainValidationOptionList = List[
    zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ]
  type LoadBalancerTlsCertificateDomainValidationRecordList = List[
    zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
  ]
  type LoadBalancerTlsCertificateList =
    List[zio.aws.lightsail.model.LoadBalancerTlsCertificate]
  type LoadBalancerTlsCertificateSummaryList =
    List[zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary]
  type LoadBalancerTlsPolicyList =
    List[zio.aws.lightsail.model.LoadBalancerTlsPolicy]
  type LogEventList = List[zio.aws.lightsail.model.LogEvent]
  type MetricDatapointList = List[zio.aws.lightsail.model.MetricDatapoint]
  type MetricStatisticList = List[zio.aws.lightsail.model.MetricStatistic]
  type NotificationTriggerList = List[zio.aws.lightsail.model.AlarmState]
  type OperationList = List[zio.aws.lightsail.model.Operation]
  type PartnerIdList = List[NonEmptyString]
  type PendingMaintenanceActionList =
    List[zio.aws.lightsail.model.PendingMaintenanceAction]
  type PortInfoList = List[zio.aws.lightsail.model.PortInfo]
  type PortList = List[Port]
  type PortMap = Map[String, zio.aws.lightsail.model.ContainerServiceProtocol]
  type RegionList = List[zio.aws.lightsail.model.Region]
  type RelationalDatabaseBlueprintList =
    List[zio.aws.lightsail.model.RelationalDatabaseBlueprint]
  type RelationalDatabaseBundleList =
    List[zio.aws.lightsail.model.RelationalDatabaseBundle]
  type RelationalDatabaseEventList =
    List[zio.aws.lightsail.model.RelationalDatabaseEvent]
  type RelationalDatabaseList = List[zio.aws.lightsail.model.RelationalDatabase]
  type RelationalDatabaseParameterList =
    List[zio.aws.lightsail.model.RelationalDatabaseParameter]
  type RelationalDatabaseSnapshotList =
    List[zio.aws.lightsail.model.RelationalDatabaseSnapshot]
  type ResourceNameList = List[ResourceName]
  type StaticIpList = List[zio.aws.lightsail.model.StaticIp]
  type StringList = List[String]
  type SubjectAlternativeNameList = List[DomainName]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.lightsail.model.Tag]
}
