package zio.aws.lightsail
import zio.aws.lightsail.model.DeleteAlarmResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.lightsail.model.{
  GetOperationsForResourceRequest,
  AttachStaticIpRequest,
  DeleteDiskSnapshotRequest,
  GetBucketsRequest,
  CreateContainerServiceRegistryLoginRequest,
  GetRelationalDatabaseSnapshotsRequest,
  DisableAddOnRequest,
  DetachCertificateFromDistributionRequest,
  CreateDistributionRequest,
  DeleteLoadBalancerTlsCertificateRequest,
  GetDistributionMetricDataRequest,
  GetOperationsRequest,
  GetCloudFormationStackRecordsRequest,
  GetRelationalDatabaseBlueprintsRequest,
  GetDiskSnapshotsRequest,
  DeleteDistributionRequest,
  UpdateContainerServiceRequest,
  GetDiskRequest,
  GetKeyPairRequest,
  DeleteContainerImageRequest,
  CreateRelationalDatabaseSnapshotRequest,
  GetContactMethodsRequest,
  DeleteAlarmRequest,
  CreateContainerServiceDeploymentRequest,
  IsVpcPeeredRequest,
  GetBucketBundlesRequest,
  DeleteKeyPairRequest,
  StopInstanceRequest,
  CreateRelationalDatabaseRequest,
  GetLoadBalancerRequest,
  AttachDiskRequest,
  GetInstanceAccessDetailsRequest,
  UpdateDistributionBundleRequest,
  GetCostEstimateRequest,
  CreateBucketAccessKeyRequest,
  CloseInstancePublicPortsRequest,
  GetAutoSnapshotsRequest,
  GetInstanceRequest,
  AllocateStaticIpRequest,
  AttachCertificateToDistributionRequest,
  UnpeerVpcRequest,
  ResetDistributionCacheRequest,
  CreateContainerServiceRequest,
  GetBundlesRequest,
  CreateCloudFormationStackRequest,
  GetContainerApiMetadataRequest,
  GetOperationRequest,
  DetachDiskRequest,
  PutAlarmRequest,
  DeleteDomainEntryRequest,
  ExportSnapshotRequest,
  CreateDiskSnapshotRequest,
  AttachLoadBalancerTlsCertificateRequest,
  GetInstanceSnapshotRequest,
  GetRelationalDatabaseEventsRequest,
  DetachStaticIpRequest,
  CopySnapshotRequest,
  SetIpAddressTypeRequest,
  RegisterContainerImageRequest,
  GetContainerImagesRequest,
  GetRelationalDatabaseRequest,
  DeleteRelationalDatabaseRequest,
  DownloadDefaultKeyPairRequest,
  CreateCertificateRequest,
  SendContactMethodVerificationRequest,
  StartRelationalDatabaseRequest,
  GetInstanceMetricDataRequest,
  UpdateLoadBalancerAttributeRequest,
  CreateRelationalDatabaseFromSnapshotRequest,
  GetInstanceSnapshotsRequest,
  GetCertificatesRequest,
  AttachInstancesToLoadBalancerRequest,
  CreateDomainEntryRequest,
  PutInstancePublicPortsRequest,
  DeleteDiskRequest,
  GetLoadBalancersRequest,
  DeleteBucketAccessKeyRequest,
  RebootRelationalDatabaseRequest,
  OpenInstancePublicPortsRequest,
  DeleteInstanceSnapshotRequest,
  CreateInstanceSnapshotRequest,
  GetDistributionBundlesRequest,
  GetInstancePortStatesRequest,
  GetLoadBalancerMetricDataRequest,
  GetRelationalDatabaseParametersRequest,
  DeleteDomainRequest,
  GetLoadBalancerTlsCertificatesRequest,
  DeleteRelationalDatabaseSnapshotRequest,
  GetAlarmsRequest,
  GetContainerLogRequest,
  GetContainerServicePowersRequest,
  DeleteBucketRequest,
  GetRelationalDatabaseSnapshotRequest,
  GetContainerServicesRequest,
  DeleteContactMethodRequest,
  CreateDiskFromSnapshotRequest,
  CreateLoadBalancerRequest,
  CreateGuiSessionAccessDetailsRequest,
  CreateKeyPairRequest,
  DeleteKnownHostKeysRequest,
  DeleteAutoSnapshotRequest,
  GetRelationalDatabaseMasterUserPasswordRequest,
  GetBlueprintsRequest,
  UpdateDomainEntryRequest,
  SetupInstanceHttpsRequest,
  DetachInstancesFromLoadBalancerRequest,
  UpdateDistributionRequest,
  CreateContactMethodRequest,
  CreateBucketRequest,
  GetInstancesRequest,
  GetRelationalDatabaseLogEventsRequest,
  UpdateInstanceMetadataOptionsRequest,
  StopRelationalDatabaseRequest,
  StopGuiSessionRequest,
  DeleteLoadBalancerRequest,
  CreateDomainRequest,
  GetRelationalDatabaseMetricDataRequest,
  GetDomainsRequest,
  GetInstanceStateRequest,
  UntagResourceRequest,
  SetResourceAccessForBucketRequest,
  GetBucketAccessKeysRequest,
  DeleteInstanceRequest,
  GetRelationalDatabaseLogStreamsRequest,
  CreateLoadBalancerTlsCertificateRequest,
  UpdateRelationalDatabaseParametersRequest,
  GetStaticIpRequest,
  UpdateBucketBundleRequest,
  GetContainerServiceMetricDataRequest,
  DeleteContainerServiceRequest,
  PeerVpcRequest,
  GetDomainRequest,
  GetRelationalDatabaseBundlesRequest,
  GetKeyPairsRequest,
  GetDistributionsRequest,
  ReleaseStaticIpRequest,
  StartGuiSessionRequest,
  UpdateRelationalDatabaseRequest,
  RebootInstanceRequest,
  CreateInstancesRequest,
  GetDistributionLatestCacheResetRequest,
  GetStaticIpsRequest,
  CreateInstancesFromSnapshotRequest,
  UpdateBucketRequest,
  GetDisksRequest,
  GetBucketMetricDataRequest,
  EnableAddOnRequest,
  ImportKeyPairRequest,
  GetRegionsRequest,
  GetExportSnapshotRecordsRequest,
  GetDiskSnapshotRequest,
  TestAlarmRequest,
  StartInstanceRequest,
  DeleteCertificateRequest,
  TagResourceRequest,
  GetContainerServiceDeploymentsRequest,
  CreateDiskRequest,
  GetRelationalDatabasesRequest,
  GetLoadBalancerTlsPoliciesRequest,
  GetSetupHistoryRequest,
  GetActiveNamesRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.lightsail.{
  LightsailAsyncClientBuilder,
  LightsailAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.lightsail.model.{
  UpdateRelationalDatabaseResponse,
  CreateInstancesFromSnapshotResponse,
  GetDomainsResponse,
  StartRelationalDatabaseResponse,
  DeleteRelationalDatabaseSnapshotResponse,
  SendContactMethodVerificationResponse,
  GetOperationsResponse,
  RegisterContainerImageResponse,
  GetLoadBalancerTlsPoliciesResponse,
  ImportKeyPairResponse,
  GetDomainResponse,
  GetAlarmsResponse,
  GetRelationalDatabaseBundlesResponse,
  GetBundlesResponse,
  CreateRelationalDatabaseResponse,
  CloseInstancePublicPortsResponse,
  GetRelationalDatabasesResponse,
  GetRelationalDatabaseMasterUserPasswordResponse,
  GetKeyPairsResponse,
  CreateCertificateResponse,
  DeleteDiskSnapshotResponse,
  CreateContainerServiceRegistryLoginResponse,
  UpdateBucketBundleResponse,
  GetActiveNamesResponse,
  CreateContactMethodResponse,
  CreateDomainResponse,
  GetLoadBalancersResponse,
  GetInstanceSnapshotResponse,
  GetDistributionLatestCacheResetResponse,
  CreateCloudFormationStackResponse,
  StopGuiSessionResponse,
  GetInstanceMetricDataResponse,
  GetCostEstimateResponse,
  StopInstanceResponse,
  GetInstancePortStatesResponse,
  UpdateBucketResponse,
  AttachInstancesToLoadBalancerResponse,
  DisableAddOnResponse,
  UpdateInstanceMetadataOptionsResponse,
  GetRelationalDatabaseSnapshotResponse,
  CreateContainerServiceResponse,
  GetDisksResponse,
  RebootInstanceResponse,
  DeleteBucketAccessKeyResponse,
  SetIpAddressTypeResponse,
  GetLoadBalancerResponse,
  CreateInstancesResponse,
  DeleteInstanceSnapshotResponse,
  GetInstanceResponse,
  DeleteAutoSnapshotResponse,
  SetupInstanceHttpsResponse,
  CreateDiskSnapshotResponse,
  UpdateRelationalDatabaseParametersResponse,
  GetRelationalDatabaseResponse,
  UpdateDomainEntryResponse,
  CreateContainerServiceDeploymentResponse,
  UnpeerVpcResponse,
  CreateRelationalDatabaseSnapshotResponse,
  GetExportSnapshotRecordsResponse,
  DeleteCertificateResponse,
  DeleteAlarmResponse,
  DeleteLoadBalancerResponse,
  GetDiskResponse,
  GetCloudFormationStackRecordsResponse,
  UpdateDistributionBundleResponse,
  GetInstanceSnapshotsResponse,
  DeleteDistributionResponse,
  CreateBucketResponse,
  GetDistributionBundlesResponse,
  GetDiskSnapshotResponse,
  GetStaticIpResponse,
  DeleteBucketResponse,
  GetLoadBalancerMetricDataResponse,
  DeleteInstanceResponse,
  UpdateLoadBalancerAttributeResponse,
  GetDiskSnapshotsResponse,
  GetStaticIpsResponse,
  CreateDomainEntryResponse,
  DeleteContainerImageResponse,
  ExportSnapshotResponse,
  CreateBucketAccessKeyResponse,
  StartGuiSessionResponse,
  CreateDiskFromSnapshotResponse,
  DownloadDefaultKeyPairResponse,
  GetDistributionMetricDataResponse,
  TestAlarmResponse,
  AttachStaticIpResponse,
  UntagResourceResponse,
  GetInstanceStateResponse,
  UpdateDistributionResponse,
  AllocateStaticIpResponse,
  AttachCertificateToDistributionResponse,
  DeleteRelationalDatabaseResponse,
  GetBlueprintsResponse,
  GetRelationalDatabaseBlueprintsResponse,
  GetContainerServicesResponse,
  StopRelationalDatabaseResponse,
  DetachInstancesFromLoadBalancerResponse,
  PeerVpcResponse,
  CreateInstanceSnapshotResponse,
  CreateDiskResponse,
  GetOperationResponse,
  GetRegionsResponse,
  DetachDiskResponse,
  GetRelationalDatabaseSnapshotsResponse,
  CreateLoadBalancerResponse,
  GetContainerServiceDeploymentsResponse,
  GetAutoSnapshotsResponse,
  PutAlarmResponse,
  AttachDiskResponse,
  CopySnapshotResponse,
  GetContactMethodsResponse,
  DeleteContactMethodResponse,
  DeleteContainerServiceResponse,
  DetachCertificateFromDistributionResponse,
  EnableAddOnResponse,
  GetRelationalDatabaseLogEventsResponse,
  GetCertificatesResponse,
  GetRelationalDatabaseMetricDataResponse,
  GetContainerApiMetadataResponse,
  DeleteKeyPairResponse,
  GetLoadBalancerTlsCertificatesResponse,
  OpenInstancePublicPortsResponse,
  PutInstancePublicPortsResponse,
  SetResourceAccessForBucketResponse,
  GetContainerImagesResponse,
  GetRelationalDatabaseParametersResponse,
  RebootRelationalDatabaseResponse,
  GetInstanceAccessDetailsResponse,
  AttachLoadBalancerTlsCertificateResponse,
  GetKeyPairResponse,
  GetContainerServicePowersResponse,
  GetRelationalDatabaseEventsResponse,
  IsVpcPeeredResponse,
  GetDistributionsResponse,
  CreateRelationalDatabaseFromSnapshotResponse,
  GetContainerLogResponse,
  GetBucketsResponse,
  ResetDistributionCacheResponse,
  CreateLoadBalancerTlsCertificateResponse,
  GetSetupHistoryResponse,
  StartInstanceResponse,
  CreateGuiSessionAccessDetailsResponse,
  UpdateContainerServiceResponse,
  CreateDistributionResponse,
  GetRelationalDatabaseLogStreamsResponse,
  DetachStaticIpResponse,
  GetBucketAccessKeysResponse,
  TagResourceResponse,
  DeleteKnownHostKeysResponse,
  DeleteDiskResponse,
  DeleteLoadBalancerTlsCertificateResponse,
  GetOperationsForResourceResponse,
  DeleteDomainEntryResponse,
  ReleaseStaticIpResponse,
  GetBucketBundlesResponse,
  CreateKeyPairResponse,
  DeleteDomainResponse,
  GetContainerServiceMetricDataResponse,
  GetInstancesResponse,
  GetBucketMetricDataResponse
}
import scala.jdk.CollectionConverters._
trait Lightsail extends AspectSupport[Lightsail] {
  val api: LightsailAsyncClient
  def putInstancePublicPorts(request: PutInstancePublicPortsRequest): IO[
    AwsError,
    zio.aws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
  ]
  def resetDistributionCache(request: ResetDistributionCacheRequest): IO[
    AwsError,
    zio.aws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
  ]
  def getRelationalDatabaseSnapshot(
      request: GetRelationalDatabaseSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
  ]
  def getKeyPair(
      request: GetKeyPairRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetKeyPairResponse.ReadOnly]
  def getInstanceAccessDetails(request: GetInstanceAccessDetailsRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
  ]
  def deleteLoadBalancerTlsCertificate(
      request: DeleteLoadBalancerTlsCertificateRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
  ]
  def createDiskSnapshot(
      request: CreateDiskSnapshotRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly]
  def deleteRelationalDatabase(request: DeleteRelationalDatabaseRequest): IO[
    AwsError,
    zio.aws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
  ]
  def releaseStaticIp(
      request: ReleaseStaticIpRequest
  ): IO[AwsError, zio.aws.lightsail.model.ReleaseStaticIpResponse.ReadOnly]
  def updateLoadBalancerAttribute(
      request: UpdateLoadBalancerAttributeRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
  ]
  def testAlarm(
      request: TestAlarmRequest
  ): IO[AwsError, zio.aws.lightsail.model.TestAlarmResponse.ReadOnly]
  def closeInstancePublicPorts(request: CloseInstancePublicPortsRequest): IO[
    AwsError,
    zio.aws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
  ]
  def getSetupHistory(
      request: GetSetupHistoryRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetSetupHistoryResponse.ReadOnly]
  def deleteContactMethod(
      request: DeleteContactMethodRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteContactMethodResponse.ReadOnly]
  def deleteDiskSnapshot(
      request: DeleteDiskSnapshotRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly]
  def putAlarm(
      request: PutAlarmRequest
  ): IO[AwsError, zio.aws.lightsail.model.PutAlarmResponse.ReadOnly]
  def getInstances(
      request: GetInstancesRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetInstancesResponse.ReadOnly]
  def createCertificate(
      request: CreateCertificateRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateCertificateResponse.ReadOnly]
  def getRelationalDatabaseLogEvents(
      request: GetRelationalDatabaseLogEventsRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
  ]
  def deleteKnownHostKeys(
      request: DeleteKnownHostKeysRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly]
  def rebootRelationalDatabase(request: RebootRelationalDatabaseRequest): IO[
    AwsError,
    zio.aws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
  ]
  def createCloudFormationStack(request: CreateCloudFormationStackRequest): IO[
    AwsError,
    zio.aws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
  ]
  def getBucketMetricData(
      request: GetBucketMetricDataRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetBucketMetricDataResponse.ReadOnly]
  def detachDisk(
      request: DetachDiskRequest
  ): IO[AwsError, zio.aws.lightsail.model.DetachDiskResponse.ReadOnly]
  def allocateStaticIp(
      request: AllocateStaticIpRequest
  ): IO[AwsError, zio.aws.lightsail.model.AllocateStaticIpResponse.ReadOnly]
  def getRelationalDatabaseEvents(
      request: GetRelationalDatabaseEventsRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
  ]
  def getOperations(
      request: GetOperationsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetOperationsResponse.ReadOnly]
  def setupInstanceHttps(
      request: SetupInstanceHttpsRequest
  ): IO[AwsError, zio.aws.lightsail.model.SetupInstanceHttpsResponse.ReadOnly]
  def getInstanceState(
      request: GetInstanceStateRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetInstanceStateResponse.ReadOnly]
  def getDomains(
      request: GetDomainsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetDomainsResponse.ReadOnly]
  def getLoadBalancers(
      request: GetLoadBalancersRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetLoadBalancersResponse.ReadOnly]
  def getContainerServices(
      request: GetContainerServicesRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetContainerServicesResponse.ReadOnly]
  def getLoadBalancerTlsCertificates(
      request: GetLoadBalancerTlsCertificatesRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
  ]
  def createRelationalDatabaseFromSnapshot(
      request: CreateRelationalDatabaseFromSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
  ]
  def getInstanceSnapshot(
      request: GetInstanceSnapshotRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly]
  def deleteContainerService(request: DeleteContainerServiceRequest): IO[
    AwsError,
    zio.aws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
  ]
  def getContainerAPIMetadata(request: GetContainerApiMetadataRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
  ]
  def getDiskSnapshot(
      request: GetDiskSnapshotRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetDiskSnapshotResponse.ReadOnly]
  def createGUISessionAccessDetails(
      request: CreateGuiSessionAccessDetailsRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse.ReadOnly
  ]
  def detachStaticIp(
      request: DetachStaticIpRequest
  ): IO[AwsError, zio.aws.lightsail.model.DetachStaticIpResponse.ReadOnly]
  def createDisk(
      request: CreateDiskRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateDiskResponse.ReadOnly]
  def getContainerImages(
      request: GetContainerImagesRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetContainerImagesResponse.ReadOnly]
  def deleteBucketAccessKey(request: DeleteBucketAccessKeyRequest): IO[
    AwsError,
    zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
  ]
  def createDomainEntry(
      request: CreateDomainEntryRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateDomainEntryResponse.ReadOnly]
  def getCostEstimate(
      request: GetCostEstimateRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetCostEstimateResponse.ReadOnly]
  def sendContactMethodVerification(
      request: SendContactMethodVerificationRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
  ]
  def getDomain(
      request: GetDomainRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetDomainResponse.ReadOnly]
  def deleteInstance(
      request: DeleteInstanceRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteInstanceResponse.ReadOnly]
  def copySnapshot(
      request: CopySnapshotRequest
  ): IO[AwsError, zio.aws.lightsail.model.CopySnapshotResponse.ReadOnly]
  def getContactMethods(
      request: GetContactMethodsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetContactMethodsResponse.ReadOnly]
  def getRelationalDatabaseBundles(
      request: GetRelationalDatabaseBundlesRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
  ]
  def detachInstancesFromLoadBalancer(
      request: DetachInstancesFromLoadBalancerRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
  ]
  def openInstancePublicPorts(request: OpenInstancePublicPortsRequest): IO[
    AwsError,
    zio.aws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
  ]
  def getInstanceMetricData(request: GetInstanceMetricDataRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
  ]
  def deleteRelationalDatabaseSnapshot(
      request: DeleteRelationalDatabaseSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
  ]
  def attachInstancesToLoadBalancer(
      request: AttachInstancesToLoadBalancerRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
  ]
  def getDistributionBundles(request: GetDistributionBundlesRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
  ]
  def getRelationalDatabaseParameters(
      request: GetRelationalDatabaseParametersRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
  ]
  def getAlarms(
      request: GetAlarmsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetAlarmsResponse.ReadOnly]
  def deleteLoadBalancer(
      request: DeleteLoadBalancerRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly]
  def getInstanceSnapshots(
      request: GetInstanceSnapshotsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly]
  def stopRelationalDatabase(request: StopRelationalDatabaseRequest): IO[
    AwsError,
    zio.aws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
  ]
  def getLoadBalancerMetricData(request: GetLoadBalancerMetricDataRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
  ]
  def attachCertificateToDistribution(
      request: AttachCertificateToDistributionRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
  ]
  def deleteCertificate(
      request: DeleteCertificateRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteCertificateResponse.ReadOnly]
  def startGUISession(
      request: StartGuiSessionRequest
  ): IO[AwsError, zio.aws.lightsail.model.StartGuiSessionResponse.ReadOnly]
  def getInstance(
      request: GetInstanceRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetInstanceResponse.ReadOnly]
  def getDistributions(
      request: GetDistributionsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetDistributionsResponse.ReadOnly]
  def getRelationalDatabases(request: GetRelationalDatabasesRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
  ]
  def attachLoadBalancerTlsCertificate(
      request: AttachLoadBalancerTlsCertificateRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
  ]
  def getOperationsForResource(request: GetOperationsForResourceRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
  ]
  def createDiskFromSnapshot(request: CreateDiskFromSnapshotRequest): IO[
    AwsError,
    zio.aws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
  ]
  def getLoadBalancer(
      request: GetLoadBalancerRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetLoadBalancerResponse.ReadOnly]
  def getBucketBundles(
      request: GetBucketBundlesRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetBucketBundlesResponse.ReadOnly]
  def deleteInstanceSnapshot(request: DeleteInstanceSnapshotRequest): IO[
    AwsError,
    zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
  ]
  def deleteDomainEntry(
      request: DeleteDomainEntryRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteDomainEntryResponse.ReadOnly]
  def updateRelationalDatabase(request: UpdateRelationalDatabaseRequest): IO[
    AwsError,
    zio.aws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
  ]
  def peerVpc(
      request: PeerVpcRequest
  ): IO[AwsError, zio.aws.lightsail.model.PeerVpcResponse.ReadOnly]
  def unpeerVpc(
      request: UnpeerVpcRequest
  ): IO[AwsError, zio.aws.lightsail.model.UnpeerVpcResponse.ReadOnly]
  def getActiveNames(
      request: GetActiveNamesRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetActiveNamesResponse.ReadOnly]
  def deleteBucket(
      request: DeleteBucketRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteBucketResponse.ReadOnly]
  def getAutoSnapshots(
      request: GetAutoSnapshotsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly]
  def startRelationalDatabase(request: StartRelationalDatabaseRequest): IO[
    AwsError,
    zio.aws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
  ]
  def createInstanceSnapshot(request: CreateInstanceSnapshotRequest): IO[
    AwsError,
    zio.aws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
  ]
  def updateDomainEntry(
      request: UpdateDomainEntryRequest
  ): IO[AwsError, zio.aws.lightsail.model.UpdateDomainEntryResponse.ReadOnly]
  def updateBucket(
      request: UpdateBucketRequest
  ): IO[AwsError, zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly]
  def rebootInstance(
      request: RebootInstanceRequest
  ): IO[AwsError, zio.aws.lightsail.model.RebootInstanceResponse.ReadOnly]
  def createContactMethod(
      request: CreateContactMethodRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateContactMethodResponse.ReadOnly]
  def getDiskSnapshots(
      request: GetDiskSnapshotsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly]
  def createBucket(
      request: CreateBucketRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateBucketResponse.ReadOnly]
  def getContainerLog(
      request: GetContainerLogRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetContainerLogResponse.ReadOnly]
  def getContainerServiceDeployments(
      request: GetContainerServiceDeploymentsRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
  ]
  def createDomain(
      request: CreateDomainRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateDomainResponse.ReadOnly]
  def setResourceAccessForBucket(
      request: SetResourceAccessForBucketRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
  ]
  def getBucketAccessKeys(
      request: GetBucketAccessKeysRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly]
  def createContainerService(request: CreateContainerServiceRequest): IO[
    AwsError,
    zio.aws.lightsail.model.CreateContainerServiceResponse.ReadOnly
  ]
  def isVpcPeered(
      request: IsVpcPeeredRequest
  ): IO[AwsError, zio.aws.lightsail.model.IsVpcPeeredResponse.ReadOnly]
  def deleteAutoSnapshot(
      request: DeleteAutoSnapshotRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly]
  def createContainerServiceRegistryLogin(
      request: CreateContainerServiceRegistryLoginRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
  ]
  def getDisk(
      request: GetDiskRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetDiskResponse.ReadOnly]
  def enableAddOn(
      request: EnableAddOnRequest
  ): IO[AwsError, zio.aws.lightsail.model.EnableAddOnResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.lightsail.model.UntagResourceResponse.ReadOnly]
  def createLoadBalancerTlsCertificate(
      request: CreateLoadBalancerTlsCertificateRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
  ]
  def getStaticIp(
      request: GetStaticIpRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetStaticIpResponse.ReadOnly]
  def attachStaticIp(
      request: AttachStaticIpRequest
  ): IO[AwsError, zio.aws.lightsail.model.AttachStaticIpResponse.ReadOnly]
  def importKeyPair(
      request: ImportKeyPairRequest
  ): IO[AwsError, zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly]
  def getDisks(
      request: GetDisksRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetDisksResponse.ReadOnly]
  def downloadDefaultKeyPair(request: DownloadDefaultKeyPairRequest): IO[
    AwsError,
    zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
  ]
  def getExportSnapshotRecords(request: GetExportSnapshotRecordsRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
  ]
  def createKeyPair(
      request: CreateKeyPairRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateKeyPairResponse.ReadOnly]
  def getLoadBalancerTlsPolicies(
      request: GetLoadBalancerTlsPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse.ReadOnly
  ]
  def getBundles(
      request: GetBundlesRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetBundlesResponse.ReadOnly]
  def registerContainerImage(request: RegisterContainerImageRequest): IO[
    AwsError,
    zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly
  ]
  def startInstance(
      request: StartInstanceRequest
  ): IO[AwsError, zio.aws.lightsail.model.StartInstanceResponse.ReadOnly]
  def getInstancePortStates(request: GetInstancePortStatesRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
  ]
  def deleteDisk(
      request: DeleteDiskRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteDiskResponse.ReadOnly]
  def updateInstanceMetadataOptions(
      request: UpdateInstanceMetadataOptionsRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse.ReadOnly
  ]
  def getBlueprints(
      request: GetBlueprintsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetBlueprintsResponse.ReadOnly]
  def deleteAlarm(request: DeleteAlarmRequest): IO[AwsError, ReadOnly]
  def createRelationalDatabaseSnapshot(
      request: CreateRelationalDatabaseSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
  ]
  def getContainerServiceMetricData(
      request: GetContainerServiceMetricDataRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
  ]
  def getRelationalDatabaseLogStreams(
      request: GetRelationalDatabaseLogStreamsRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
  ]
  def updateRelationalDatabaseParameters(
      request: UpdateRelationalDatabaseParametersRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
  ]
  def createContainerServiceDeployment(
      request: CreateContainerServiceDeploymentRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
  ]
  def getDistributionLatestCacheReset(
      request: GetDistributionLatestCacheResetRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
  ]
  def updateDistributionBundle(request: UpdateDistributionBundleRequest): IO[
    AwsError,
    zio.aws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
  ]
  def deleteKeyPair(
      request: DeleteKeyPairRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteKeyPairResponse.ReadOnly]
  def updateBucketBundle(
      request: UpdateBucketBundleRequest
  ): IO[AwsError, zio.aws.lightsail.model.UpdateBucketBundleResponse.ReadOnly]
  def getStaticIps(
      request: GetStaticIpsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetStaticIpsResponse.ReadOnly]
  def createRelationalDatabase(request: CreateRelationalDatabaseRequest): IO[
    AwsError,
    zio.aws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
  ]
  def getCertificates(
      request: GetCertificatesRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.lightsail.model.TagResourceResponse.ReadOnly]
  def deleteDomain(
      request: DeleteDomainRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteDomainResponse.ReadOnly]
  def createBucketAccessKey(request: CreateBucketAccessKeyRequest): IO[
    AwsError,
    zio.aws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
  ]
  def getRelationalDatabaseSnapshots(
      request: GetRelationalDatabaseSnapshotsRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
  ]
  def createInstancesFromSnapshot(
      request: CreateInstancesFromSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
  ]
  def exportSnapshot(
      request: ExportSnapshotRequest
  ): IO[AwsError, zio.aws.lightsail.model.ExportSnapshotResponse.ReadOnly]
  def attachDisk(
      request: AttachDiskRequest
  ): IO[AwsError, zio.aws.lightsail.model.AttachDiskResponse.ReadOnly]
  def setIpAddressType(
      request: SetIpAddressTypeRequest
  ): IO[AwsError, zio.aws.lightsail.model.SetIpAddressTypeResponse.ReadOnly]
  def getRegions(
      request: GetRegionsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetRegionsResponse.ReadOnly]
  def getRelationalDatabaseMetricData(
      request: GetRelationalDatabaseMetricDataRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
  ]
  def getOperation(
      request: GetOperationRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetOperationResponse.ReadOnly]
  def stopInstance(
      request: StopInstanceRequest
  ): IO[AwsError, zio.aws.lightsail.model.StopInstanceResponse.ReadOnly]
  def getDistributionMetricData(request: GetDistributionMetricDataRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
  ]
  def getKeyPairs(
      request: GetKeyPairsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetKeyPairsResponse.ReadOnly]
  def disableAddOn(
      request: DisableAddOnRequest
  ): IO[AwsError, zio.aws.lightsail.model.DisableAddOnResponse.ReadOnly]
  def createInstances(
      request: CreateInstancesRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateInstancesResponse.ReadOnly]
  def createLoadBalancer(
      request: CreateLoadBalancerRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateLoadBalancerResponse.ReadOnly]
  def getRelationalDatabaseBlueprints(
      request: GetRelationalDatabaseBlueprintsRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
  ]
  def stopGUISession(
      request: StopGuiSessionRequest
  ): IO[AwsError, zio.aws.lightsail.model.StopGuiSessionResponse.ReadOnly]
  def detachCertificateFromDistribution(
      request: DetachCertificateFromDistributionRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
  ]
  def getRelationalDatabaseMasterUserPassword(
      request: GetRelationalDatabaseMasterUserPasswordRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
  ]
  def updateContainerService(request: UpdateContainerServiceRequest): IO[
    AwsError,
    zio.aws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
  ]
  def getContainerServicePowers(request: GetContainerServicePowersRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
  ]
  def getRelationalDatabase(request: GetRelationalDatabaseRequest): IO[
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
  ]
  def getBuckets(
      request: GetBucketsRequest
  ): IO[AwsError, zio.aws.lightsail.model.GetBucketsResponse.ReadOnly]
  def getCloudFormationStackRecords(
      request: GetCloudFormationStackRecordsRequest
  ): IO[
    AwsError,
    zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
  ]
  def updateDistribution(
      request: UpdateDistributionRequest
  ): IO[AwsError, zio.aws.lightsail.model.UpdateDistributionResponse.ReadOnly]
  def deleteDistribution(
      request: DeleteDistributionRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteDistributionResponse.ReadOnly]
  def deleteContainerImage(
      request: DeleteContainerImageRequest
  ): IO[AwsError, zio.aws.lightsail.model.DeleteContainerImageResponse.ReadOnly]
  def createDistribution(
      request: CreateDistributionRequest
  ): IO[AwsError, zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly]
}
object Lightsail {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Lightsail] = customized(
    identity
  )
  def customized(
      customization: LightsailAsyncClientBuilder => LightsailAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Lightsail] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: LightsailAsyncClientBuilder => LightsailAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Lightsail] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = LightsailAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[LightsailAsyncClient, LightsailAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[LightsailAsyncClient, LightsailAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new LightsailImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class LightsailImpl[R](
      override val api: LightsailAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Lightsail
      with AwsServiceBase[R] {
    override val serviceName: String = "Lightsail"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LightsailImpl[R1] = new LightsailImpl(api, newAspect, r)
    def putInstancePublicPorts(request: PutInstancePublicPortsRequest): IO[
      AwsError,
      zio.aws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest,
      PutInstancePublicPortsResponse
    ]("putInstancePublicPorts", api.putInstancePublicPorts)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.PutInstancePublicPortsResponse.wrap)
      .provideEnvironment(r)
    def resetDistributionCache(request: ResetDistributionCacheRequest): IO[
      AwsError,
      zio.aws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest,
      ResetDistributionCacheResponse
    ]("resetDistributionCache", api.resetDistributionCache)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.ResetDistributionCacheResponse.wrap)
      .provideEnvironment(r)
    def getRelationalDatabaseSnapshot(
        request: GetRelationalDatabaseSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest,
      GetRelationalDatabaseSnapshotResponse
    ]("getRelationalDatabaseSnapshot", api.getRelationalDatabaseSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse.wrap)
      .provideEnvironment(r)
    def getKeyPair(
        request: GetKeyPairRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetKeyPairResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest,
        GetKeyPairResponse
      ]("getKeyPair", api.getKeyPair)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetKeyPairResponse.wrap)
        .provideEnvironment(r)
    def getInstanceAccessDetails(request: GetInstanceAccessDetailsRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest,
      GetInstanceAccessDetailsResponse
    ]("getInstanceAccessDetails", api.getInstanceAccessDetails)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetInstanceAccessDetailsResponse.wrap)
      .provideEnvironment(r)
    def deleteLoadBalancerTlsCertificate(
        request: DeleteLoadBalancerTlsCertificateRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest,
      DeleteLoadBalancerTlsCertificateResponse
    ]("deleteLoadBalancerTlsCertificate", api.deleteLoadBalancerTlsCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.wrap)
      .provideEnvironment(r)
    def createDiskSnapshot(request: CreateDiskSnapshotRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest,
      CreateDiskSnapshotResponse
    ]("createDiskSnapshot", api.createDiskSnapshot)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.CreateDiskSnapshotResponse.wrap)
      .provideEnvironment(r)
    def deleteRelationalDatabase(request: DeleteRelationalDatabaseRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest,
      DeleteRelationalDatabaseResponse
    ]("deleteRelationalDatabase", api.deleteRelationalDatabase)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.DeleteRelationalDatabaseResponse.wrap)
      .provideEnvironment(r)
    def releaseStaticIp(
        request: ReleaseStaticIpRequest
    ): IO[AwsError, zio.aws.lightsail.model.ReleaseStaticIpResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest,
        ReleaseStaticIpResponse
      ]("releaseStaticIp", api.releaseStaticIp)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.ReleaseStaticIpResponse.wrap)
        .provideEnvironment(r)
    def updateLoadBalancerAttribute(
        request: UpdateLoadBalancerAttributeRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest,
      UpdateLoadBalancerAttributeResponse
    ]("updateLoadBalancerAttribute", api.updateLoadBalancerAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.UpdateLoadBalancerAttributeResponse.wrap)
      .provideEnvironment(r)
    def testAlarm(
        request: TestAlarmRequest
    ): IO[AwsError, zio.aws.lightsail.model.TestAlarmResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.TestAlarmRequest,
        TestAlarmResponse
      ]("testAlarm", api.testAlarm)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.TestAlarmResponse.wrap)
        .provideEnvironment(r)
    def closeInstancePublicPorts(request: CloseInstancePublicPortsRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest,
      CloseInstancePublicPortsResponse
    ]("closeInstancePublicPorts", api.closeInstancePublicPorts)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CloseInstancePublicPortsResponse.wrap)
      .provideEnvironment(r)
    def getSetupHistory(
        request: GetSetupHistoryRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetSetupHistoryResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetSetupHistoryRequest,
        GetSetupHistoryResponse
      ]("getSetupHistory", api.getSetupHistory)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetSetupHistoryResponse.wrap)
        .provideEnvironment(r)
    def deleteContactMethod(request: DeleteContactMethodRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteContactMethodResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest,
      DeleteContactMethodResponse
    ]("deleteContactMethod", api.deleteContactMethod)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.DeleteContactMethodResponse.wrap)
      .provideEnvironment(r)
    def deleteDiskSnapshot(request: DeleteDiskSnapshotRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest,
      DeleteDiskSnapshotResponse
    ]("deleteDiskSnapshot", api.deleteDiskSnapshot)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.DeleteDiskSnapshotResponse.wrap)
      .provideEnvironment(r)
    def putAlarm(
        request: PutAlarmRequest
    ): IO[AwsError, zio.aws.lightsail.model.PutAlarmResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.PutAlarmRequest,
        PutAlarmResponse
      ]("putAlarm", api.putAlarm)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.PutAlarmResponse.wrap)
        .provideEnvironment(r)
    def getInstances(
        request: GetInstancesRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetInstancesRequest,
        GetInstancesResponse
      ]("getInstances", api.getInstances)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetInstancesResponse.wrap)
        .provideEnvironment(r)
    def createCertificate(request: CreateCertificateRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest,
      CreateCertificateResponse
    ]("createCertificate", api.createCertificate)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.CreateCertificateResponse.wrap)
      .provideEnvironment(r)
    def getRelationalDatabaseLogEvents(
        request: GetRelationalDatabaseLogEventsRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest,
      GetRelationalDatabaseLogEventsResponse
    ]("getRelationalDatabaseLogEvents", api.getRelationalDatabaseLogEvents)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse.wrap)
      .provideEnvironment(r)
    def deleteKnownHostKeys(request: DeleteKnownHostKeysRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest,
      DeleteKnownHostKeysResponse
    ]("deleteKnownHostKeys", api.deleteKnownHostKeys)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.DeleteKnownHostKeysResponse.wrap)
      .provideEnvironment(r)
    def rebootRelationalDatabase(request: RebootRelationalDatabaseRequest): IO[
      AwsError,
      zio.aws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest,
      RebootRelationalDatabaseResponse
    ]("rebootRelationalDatabase", api.rebootRelationalDatabase)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.RebootRelationalDatabaseResponse.wrap)
      .provideEnvironment(r)
    def createCloudFormationStack(
        request: CreateCloudFormationStackRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest,
      CreateCloudFormationStackResponse
    ]("createCloudFormationStack", api.createCloudFormationStack)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateCloudFormationStackResponse.wrap)
      .provideEnvironment(r)
    def getBucketMetricData(request: GetBucketMetricDataRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetBucketMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest,
      GetBucketMetricDataResponse
    ]("getBucketMetricData", api.getBucketMetricData)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.GetBucketMetricDataResponse.wrap)
      .provideEnvironment(r)
    def detachDisk(
        request: DetachDiskRequest
    ): IO[AwsError, zio.aws.lightsail.model.DetachDiskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.DetachDiskRequest,
        DetachDiskResponse
      ]("detachDisk", api.detachDisk)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.DetachDiskResponse.wrap)
        .provideEnvironment(r)
    def allocateStaticIp(
        request: AllocateStaticIpRequest
    ): IO[AwsError, zio.aws.lightsail.model.AllocateStaticIpResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest,
        AllocateStaticIpResponse
      ]("allocateStaticIp", api.allocateStaticIp)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.AllocateStaticIpResponse.wrap)
        .provideEnvironment(r)
    def getRelationalDatabaseEvents(
        request: GetRelationalDatabaseEventsRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest,
      GetRelationalDatabaseEventsResponse
    ]("getRelationalDatabaseEvents", api.getRelationalDatabaseEvents)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse.wrap)
      .provideEnvironment(r)
    def getOperations(
        request: GetOperationsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetOperationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetOperationsRequest,
        GetOperationsResponse
      ]("getOperations", api.getOperations)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetOperationsResponse.wrap)
        .provideEnvironment(r)
    def setupInstanceHttps(request: SetupInstanceHttpsRequest): IO[
      AwsError,
      zio.aws.lightsail.model.SetupInstanceHttpsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.SetupInstanceHttpsRequest,
      SetupInstanceHttpsResponse
    ]("setupInstanceHttps", api.setupInstanceHttps)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.SetupInstanceHttpsResponse.wrap)
      .provideEnvironment(r)
    def getInstanceState(
        request: GetInstanceStateRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetInstanceStateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest,
        GetInstanceStateResponse
      ]("getInstanceState", api.getInstanceState)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetInstanceStateResponse.wrap)
        .provideEnvironment(r)
    def getDomains(
        request: GetDomainsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetDomainsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetDomainsRequest,
        GetDomainsResponse
      ]("getDomains", api.getDomains)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetDomainsResponse.wrap)
        .provideEnvironment(r)
    def getLoadBalancers(
        request: GetLoadBalancersRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetLoadBalancersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest,
        GetLoadBalancersResponse
      ]("getLoadBalancers", api.getLoadBalancers)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetLoadBalancersResponse.wrap)
        .provideEnvironment(r)
    def getContainerServices(request: GetContainerServicesRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetContainerServicesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest,
      GetContainerServicesResponse
    ]("getContainerServices", api.getContainerServices)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.GetContainerServicesResponse.wrap)
      .provideEnvironment(r)
    def getLoadBalancerTlsCertificates(
        request: GetLoadBalancerTlsCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest,
      GetLoadBalancerTlsCertificatesResponse
    ]("getLoadBalancerTlsCertificates", api.getLoadBalancerTlsCertificates)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.wrap)
      .provideEnvironment(r)
    def createRelationalDatabaseFromSnapshot(
        request: CreateRelationalDatabaseFromSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest,
      CreateRelationalDatabaseFromSnapshotResponse
    ](
      "createRelationalDatabaseFromSnapshot",
      api.createRelationalDatabaseFromSnapshot
    )(request.buildAwsValue())
      .map(
        zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.wrap
      )
      .provideEnvironment(r)
    def getInstanceSnapshot(request: GetInstanceSnapshotRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest,
      GetInstanceSnapshotResponse
    ]("getInstanceSnapshot", api.getInstanceSnapshot)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.GetInstanceSnapshotResponse.wrap)
      .provideEnvironment(r)
    def deleteContainerService(request: DeleteContainerServiceRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest,
      DeleteContainerServiceResponse
    ]("deleteContainerService", api.deleteContainerService)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.DeleteContainerServiceResponse.wrap)
      .provideEnvironment(r)
    def getContainerAPIMetadata(request: GetContainerApiMetadataRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataRequest,
      GetContainerApiMetadataResponse
    ]("getContainerAPIMetadata", api.getContainerAPIMetadata)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetContainerApiMetadataResponse.wrap)
      .provideEnvironment(r)
    def getDiskSnapshot(
        request: GetDiskSnapshotRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetDiskSnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest,
        GetDiskSnapshotResponse
      ]("getDiskSnapshot", api.getDiskSnapshot)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetDiskSnapshotResponse.wrap)
        .provideEnvironment(r)
    def createGUISessionAccessDetails(
        request: CreateGuiSessionAccessDetailsRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsRequest,
      CreateGuiSessionAccessDetailsResponse
    ]("createGUISessionAccessDetails", api.createGUISessionAccessDetails)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse.wrap)
      .provideEnvironment(r)
    def detachStaticIp(
        request: DetachStaticIpRequest
    ): IO[AwsError, zio.aws.lightsail.model.DetachStaticIpResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest,
        DetachStaticIpResponse
      ]("detachStaticIp", api.detachStaticIp)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.DetachStaticIpResponse.wrap)
        .provideEnvironment(r)
    def createDisk(
        request: CreateDiskRequest
    ): IO[AwsError, zio.aws.lightsail.model.CreateDiskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.CreateDiskRequest,
        CreateDiskResponse
      ]("createDisk", api.createDisk)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.CreateDiskResponse.wrap)
        .provideEnvironment(r)
    def getContainerImages(request: GetContainerImagesRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetContainerImagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest,
      GetContainerImagesResponse
    ]("getContainerImages", api.getContainerImages)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.GetContainerImagesResponse.wrap)
      .provideEnvironment(r)
    def deleteBucketAccessKey(request: DeleteBucketAccessKeyRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest,
      DeleteBucketAccessKeyResponse
    ]("deleteBucketAccessKey", api.deleteBucketAccessKey)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.wrap)
      .provideEnvironment(r)
    def createDomainEntry(request: CreateDomainEntryRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateDomainEntryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest,
      CreateDomainEntryResponse
    ]("createDomainEntry", api.createDomainEntry)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.CreateDomainEntryResponse.wrap)
      .provideEnvironment(r)
    def getCostEstimate(
        request: GetCostEstimateRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetCostEstimateResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetCostEstimateRequest,
        GetCostEstimateResponse
      ]("getCostEstimate", api.getCostEstimate)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetCostEstimateResponse.wrap)
        .provideEnvironment(r)
    def sendContactMethodVerification(
        request: SendContactMethodVerificationRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest,
      SendContactMethodVerificationResponse
    ]("sendContactMethodVerification", api.sendContactMethodVerification)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.SendContactMethodVerificationResponse.wrap)
      .provideEnvironment(r)
    def getDomain(
        request: GetDomainRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetDomainRequest,
        GetDomainResponse
      ]("getDomain", api.getDomain)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetDomainResponse.wrap)
        .provideEnvironment(r)
    def deleteInstance(
        request: DeleteInstanceRequest
    ): IO[AwsError, zio.aws.lightsail.model.DeleteInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest,
        DeleteInstanceResponse
      ]("deleteInstance", api.deleteInstance)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.DeleteInstanceResponse.wrap)
        .provideEnvironment(r)
    def copySnapshot(
        request: CopySnapshotRequest
    ): IO[AwsError, zio.aws.lightsail.model.CopySnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest,
        CopySnapshotResponse
      ]("copySnapshot", api.copySnapshot)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.CopySnapshotResponse.wrap)
        .provideEnvironment(r)
    def getContactMethods(request: GetContactMethodsRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetContactMethodsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest,
      GetContactMethodsResponse
    ]("getContactMethods", api.getContactMethods)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.GetContactMethodsResponse.wrap)
      .provideEnvironment(r)
    def getRelationalDatabaseBundles(
        request: GetRelationalDatabaseBundlesRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest,
      GetRelationalDatabaseBundlesResponse
    ]("getRelationalDatabaseBundles", api.getRelationalDatabaseBundles)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse.wrap)
      .provideEnvironment(r)
    def detachInstancesFromLoadBalancer(
        request: DetachInstancesFromLoadBalancerRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest,
      DetachInstancesFromLoadBalancerResponse
    ]("detachInstancesFromLoadBalancer", api.detachInstancesFromLoadBalancer)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.DetachInstancesFromLoadBalancerResponse.wrap)
      .provideEnvironment(r)
    def openInstancePublicPorts(request: OpenInstancePublicPortsRequest): IO[
      AwsError,
      zio.aws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest,
      OpenInstancePublicPortsResponse
    ]("openInstancePublicPorts", api.openInstancePublicPorts)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.OpenInstancePublicPortsResponse.wrap)
      .provideEnvironment(r)
    def getInstanceMetricData(request: GetInstanceMetricDataRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest,
      GetInstanceMetricDataResponse
    ]("getInstanceMetricData", api.getInstanceMetricData)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetInstanceMetricDataResponse.wrap)
      .provideEnvironment(r)
    def deleteRelationalDatabaseSnapshot(
        request: DeleteRelationalDatabaseSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest,
      DeleteRelationalDatabaseSnapshotResponse
    ]("deleteRelationalDatabaseSnapshot", api.deleteRelationalDatabaseSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.wrap)
      .provideEnvironment(r)
    def attachInstancesToLoadBalancer(
        request: AttachInstancesToLoadBalancerRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest,
      AttachInstancesToLoadBalancerResponse
    ]("attachInstancesToLoadBalancer", api.attachInstancesToLoadBalancer)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.AttachInstancesToLoadBalancerResponse.wrap)
      .provideEnvironment(r)
    def getDistributionBundles(request: GetDistributionBundlesRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesRequest,
      GetDistributionBundlesResponse
    ]("getDistributionBundles", api.getDistributionBundles)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetDistributionBundlesResponse.wrap)
      .provideEnvironment(r)
    def getRelationalDatabaseParameters(
        request: GetRelationalDatabaseParametersRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest,
      GetRelationalDatabaseParametersResponse
    ]("getRelationalDatabaseParameters", api.getRelationalDatabaseParameters)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse.wrap)
      .provideEnvironment(r)
    def getAlarms(
        request: GetAlarmsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetAlarmsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest,
        GetAlarmsResponse
      ]("getAlarms", api.getAlarms)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetAlarmsResponse.wrap)
        .provideEnvironment(r)
    def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest,
      DeleteLoadBalancerResponse
    ]("deleteLoadBalancer", api.deleteLoadBalancer)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.DeleteLoadBalancerResponse.wrap)
      .provideEnvironment(r)
    def getInstanceSnapshots(request: GetInstanceSnapshotsRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest,
      GetInstanceSnapshotsResponse
    ]("getInstanceSnapshots", api.getInstanceSnapshots)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.GetInstanceSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def stopRelationalDatabase(request: StopRelationalDatabaseRequest): IO[
      AwsError,
      zio.aws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest,
      StopRelationalDatabaseResponse
    ]("stopRelationalDatabase", api.stopRelationalDatabase)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.StopRelationalDatabaseResponse.wrap)
      .provideEnvironment(r)
    def getLoadBalancerMetricData(
        request: GetLoadBalancerMetricDataRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest,
      GetLoadBalancerMetricDataResponse
    ]("getLoadBalancerMetricData", api.getLoadBalancerMetricData)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse.wrap)
      .provideEnvironment(r)
    def attachCertificateToDistribution(
        request: AttachCertificateToDistributionRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest,
      AttachCertificateToDistributionResponse
    ]("attachCertificateToDistribution", api.attachCertificateToDistribution)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.AttachCertificateToDistributionResponse.wrap)
      .provideEnvironment(r)
    def deleteCertificate(request: DeleteCertificateRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest,
      DeleteCertificateResponse
    ]("deleteCertificate", api.deleteCertificate)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.DeleteCertificateResponse.wrap)
      .provideEnvironment(r)
    def startGUISession(
        request: StartGuiSessionRequest
    ): IO[AwsError, zio.aws.lightsail.model.StartGuiSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.StartGuiSessionRequest,
        StartGuiSessionResponse
      ]("startGUISession", api.startGUISession)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.StartGuiSessionResponse.wrap)
        .provideEnvironment(r)
    def getInstance(
        request: GetInstanceRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetInstanceRequest,
        GetInstanceResponse
      ]("getInstance", api.getInstance)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetInstanceResponse.wrap)
        .provideEnvironment(r)
    def getDistributions(
        request: GetDistributionsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetDistributionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest,
        GetDistributionsResponse
      ]("getDistributions", api.getDistributions)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetDistributionsResponse.wrap)
        .provideEnvironment(r)
    def getRelationalDatabases(request: GetRelationalDatabasesRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest,
      GetRelationalDatabasesResponse
    ]("getRelationalDatabases", api.getRelationalDatabases)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabasesResponse.wrap)
      .provideEnvironment(r)
    def attachLoadBalancerTlsCertificate(
        request: AttachLoadBalancerTlsCertificateRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest,
      AttachLoadBalancerTlsCertificateResponse
    ]("attachLoadBalancerTlsCertificate", api.attachLoadBalancerTlsCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.wrap)
      .provideEnvironment(r)
    def getOperationsForResource(request: GetOperationsForResourceRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest,
      GetOperationsForResourceResponse
    ]("getOperationsForResource", api.getOperationsForResource)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetOperationsForResourceResponse.wrap)
      .provideEnvironment(r)
    def createDiskFromSnapshot(request: CreateDiskFromSnapshotRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest,
      CreateDiskFromSnapshotResponse
    ]("createDiskFromSnapshot", api.createDiskFromSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateDiskFromSnapshotResponse.wrap)
      .provideEnvironment(r)
    def getLoadBalancer(
        request: GetLoadBalancerRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetLoadBalancerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest,
        GetLoadBalancerResponse
      ]("getLoadBalancer", api.getLoadBalancer)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetLoadBalancerResponse.wrap)
        .provideEnvironment(r)
    def getBucketBundles(
        request: GetBucketBundlesRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetBucketBundlesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest,
        GetBucketBundlesResponse
      ]("getBucketBundles", api.getBucketBundles)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetBucketBundlesResponse.wrap)
        .provideEnvironment(r)
    def deleteInstanceSnapshot(request: DeleteInstanceSnapshotRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest,
      DeleteInstanceSnapshotResponse
    ]("deleteInstanceSnapshot", api.deleteInstanceSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.wrap)
      .provideEnvironment(r)
    def deleteDomainEntry(request: DeleteDomainEntryRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteDomainEntryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest,
      DeleteDomainEntryResponse
    ]("deleteDomainEntry", api.deleteDomainEntry)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.DeleteDomainEntryResponse.wrap)
      .provideEnvironment(r)
    def updateRelationalDatabase(request: UpdateRelationalDatabaseRequest): IO[
      AwsError,
      zio.aws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest,
      UpdateRelationalDatabaseResponse
    ]("updateRelationalDatabase", api.updateRelationalDatabase)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.UpdateRelationalDatabaseResponse.wrap)
      .provideEnvironment(r)
    def peerVpc(
        request: PeerVpcRequest
    ): IO[AwsError, zio.aws.lightsail.model.PeerVpcResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.PeerVpcRequest,
        PeerVpcResponse
      ]("peerVpc", api.peerVpc)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.PeerVpcResponse.wrap)
        .provideEnvironment(r)
    def unpeerVpc(
        request: UnpeerVpcRequest
    ): IO[AwsError, zio.aws.lightsail.model.UnpeerVpcResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest,
        UnpeerVpcResponse
      ]("unpeerVpc", api.unpeerVpc)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.UnpeerVpcResponse.wrap)
        .provideEnvironment(r)
    def getActiveNames(
        request: GetActiveNamesRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetActiveNamesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest,
        GetActiveNamesResponse
      ]("getActiveNames", api.getActiveNames)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetActiveNamesResponse.wrap)
        .provideEnvironment(r)
    def deleteBucket(
        request: DeleteBucketRequest
    ): IO[AwsError, zio.aws.lightsail.model.DeleteBucketResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest,
        DeleteBucketResponse
      ]("deleteBucket", api.deleteBucket)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.DeleteBucketResponse.wrap)
        .provideEnvironment(r)
    def getAutoSnapshots(
        request: GetAutoSnapshotsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest,
        GetAutoSnapshotsResponse
      ]("getAutoSnapshots", api.getAutoSnapshots)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetAutoSnapshotsResponse.wrap)
        .provideEnvironment(r)
    def startRelationalDatabase(request: StartRelationalDatabaseRequest): IO[
      AwsError,
      zio.aws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest,
      StartRelationalDatabaseResponse
    ]("startRelationalDatabase", api.startRelationalDatabase)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.StartRelationalDatabaseResponse.wrap)
      .provideEnvironment(r)
    def createInstanceSnapshot(request: CreateInstanceSnapshotRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest,
      CreateInstanceSnapshotResponse
    ]("createInstanceSnapshot", api.createInstanceSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateInstanceSnapshotResponse.wrap)
      .provideEnvironment(r)
    def updateDomainEntry(request: UpdateDomainEntryRequest): IO[
      AwsError,
      zio.aws.lightsail.model.UpdateDomainEntryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest,
      UpdateDomainEntryResponse
    ]("updateDomainEntry", api.updateDomainEntry)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.UpdateDomainEntryResponse.wrap)
      .provideEnvironment(r)
    def updateBucket(
        request: UpdateBucketRequest
    ): IO[AwsError, zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest,
        UpdateBucketResponse
      ]("updateBucket", api.updateBucket)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.UpdateBucketResponse.wrap)
        .provideEnvironment(r)
    def rebootInstance(
        request: RebootInstanceRequest
    ): IO[AwsError, zio.aws.lightsail.model.RebootInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest,
        RebootInstanceResponse
      ]("rebootInstance", api.rebootInstance)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.RebootInstanceResponse.wrap)
        .provideEnvironment(r)
    def createContactMethod(request: CreateContactMethodRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateContactMethodResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest,
      CreateContactMethodResponse
    ]("createContactMethod", api.createContactMethod)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.CreateContactMethodResponse.wrap)
      .provideEnvironment(r)
    def getDiskSnapshots(
        request: GetDiskSnapshotsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest,
        GetDiskSnapshotsResponse
      ]("getDiskSnapshots", api.getDiskSnapshots)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetDiskSnapshotsResponse.wrap)
        .provideEnvironment(r)
    def createBucket(
        request: CreateBucketRequest
    ): IO[AwsError, zio.aws.lightsail.model.CreateBucketResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.CreateBucketRequest,
        CreateBucketResponse
      ]("createBucket", api.createBucket)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.CreateBucketResponse.wrap)
        .provideEnvironment(r)
    def getContainerLog(
        request: GetContainerLogRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetContainerLogResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest,
        GetContainerLogResponse
      ]("getContainerLog", api.getContainerLog)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetContainerLogResponse.wrap)
        .provideEnvironment(r)
    def getContainerServiceDeployments(
        request: GetContainerServiceDeploymentsRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest,
      GetContainerServiceDeploymentsResponse
    ]("getContainerServiceDeployments", api.getContainerServiceDeployments)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse.wrap)
      .provideEnvironment(r)
    def createDomain(
        request: CreateDomainRequest
    ): IO[AwsError, zio.aws.lightsail.model.CreateDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.CreateDomainRequest,
        CreateDomainResponse
      ]("createDomain", api.createDomain)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.CreateDomainResponse.wrap)
        .provideEnvironment(r)
    def setResourceAccessForBucket(
        request: SetResourceAccessForBucketRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest,
      SetResourceAccessForBucketResponse
    ]("setResourceAccessForBucket", api.setResourceAccessForBucket)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.SetResourceAccessForBucketResponse.wrap)
      .provideEnvironment(r)
    def getBucketAccessKeys(request: GetBucketAccessKeysRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest,
      GetBucketAccessKeysResponse
    ]("getBucketAccessKeys", api.getBucketAccessKeys)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.GetBucketAccessKeysResponse.wrap)
      .provideEnvironment(r)
    def createContainerService(request: CreateContainerServiceRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateContainerServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest,
      CreateContainerServiceResponse
    ]("createContainerService", api.createContainerService)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateContainerServiceResponse.wrap)
      .provideEnvironment(r)
    def isVpcPeered(
        request: IsVpcPeeredRequest
    ): IO[AwsError, zio.aws.lightsail.model.IsVpcPeeredResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest,
        IsVpcPeeredResponse
      ]("isVpcPeered", api.isVpcPeered)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.IsVpcPeeredResponse.wrap)
        .provideEnvironment(r)
    def deleteAutoSnapshot(request: DeleteAutoSnapshotRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest,
      DeleteAutoSnapshotResponse
    ]("deleteAutoSnapshot", api.deleteAutoSnapshot)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.DeleteAutoSnapshotResponse.wrap)
      .provideEnvironment(r)
    def createContainerServiceRegistryLogin(
        request: CreateContainerServiceRegistryLoginRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginRequest,
      CreateContainerServiceRegistryLoginResponse
    ](
      "createContainerServiceRegistryLogin",
      api.createContainerServiceRegistryLogin
    )(request.buildAwsValue())
      .map(
        zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse.wrap
      )
      .provideEnvironment(r)
    def getDisk(
        request: GetDiskRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetDiskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetDiskRequest,
        GetDiskResponse
      ]("getDisk", api.getDisk)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetDiskResponse.wrap)
        .provideEnvironment(r)
    def enableAddOn(
        request: EnableAddOnRequest
    ): IO[AwsError, zio.aws.lightsail.model.EnableAddOnResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest,
        EnableAddOnResponse
      ]("enableAddOn", api.enableAddOn)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.EnableAddOnResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.lightsail.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createLoadBalancerTlsCertificate(
        request: CreateLoadBalancerTlsCertificateRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest,
      CreateLoadBalancerTlsCertificateResponse
    ]("createLoadBalancerTlsCertificate", api.createLoadBalancerTlsCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.wrap)
      .provideEnvironment(r)
    def getStaticIp(
        request: GetStaticIpRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetStaticIpResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest,
        GetStaticIpResponse
      ]("getStaticIp", api.getStaticIp)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetStaticIpResponse.wrap)
        .provideEnvironment(r)
    def attachStaticIp(
        request: AttachStaticIpRequest
    ): IO[AwsError, zio.aws.lightsail.model.AttachStaticIpResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest,
        AttachStaticIpResponse
      ]("attachStaticIp", api.attachStaticIp)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.AttachStaticIpResponse.wrap)
        .provideEnvironment(r)
    def importKeyPair(
        request: ImportKeyPairRequest
    ): IO[AwsError, zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest,
        ImportKeyPairResponse
      ]("importKeyPair", api.importKeyPair)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.ImportKeyPairResponse.wrap)
        .provideEnvironment(r)
    def getDisks(
        request: GetDisksRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetDisksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetDisksRequest,
        GetDisksResponse
      ]("getDisks", api.getDisks)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetDisksResponse.wrap)
        .provideEnvironment(r)
    def downloadDefaultKeyPair(request: DownloadDefaultKeyPairRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest,
      DownloadDefaultKeyPairResponse
    ]("downloadDefaultKeyPair", api.downloadDefaultKeyPair)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.wrap)
      .provideEnvironment(r)
    def getExportSnapshotRecords(request: GetExportSnapshotRecordsRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest,
      GetExportSnapshotRecordsResponse
    ]("getExportSnapshotRecords", api.getExportSnapshotRecords)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetExportSnapshotRecordsResponse.wrap)
      .provideEnvironment(r)
    def createKeyPair(
        request: CreateKeyPairRequest
    ): IO[AwsError, zio.aws.lightsail.model.CreateKeyPairResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest,
        CreateKeyPairResponse
      ]("createKeyPair", api.createKeyPair)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.CreateKeyPairResponse.wrap)
        .provideEnvironment(r)
    def getLoadBalancerTlsPolicies(
        request: GetLoadBalancerTlsPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest,
      GetLoadBalancerTlsPoliciesResponse
    ]("getLoadBalancerTlsPolicies", api.getLoadBalancerTlsPolicies)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse.wrap)
      .provideEnvironment(r)
    def getBundles(
        request: GetBundlesRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetBundlesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetBundlesRequest,
        GetBundlesResponse
      ]("getBundles", api.getBundles)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetBundlesResponse.wrap)
        .provideEnvironment(r)
    def registerContainerImage(request: RegisterContainerImageRequest): IO[
      AwsError,
      zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest,
      RegisterContainerImageResponse
    ]("registerContainerImage", api.registerContainerImage)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.RegisterContainerImageResponse.wrap)
      .provideEnvironment(r)
    def startInstance(
        request: StartInstanceRequest
    ): IO[AwsError, zio.aws.lightsail.model.StartInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.StartInstanceRequest,
        StartInstanceResponse
      ]("startInstance", api.startInstance)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.StartInstanceResponse.wrap)
        .provideEnvironment(r)
    def getInstancePortStates(request: GetInstancePortStatesRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest,
      GetInstancePortStatesResponse
    ]("getInstancePortStates", api.getInstancePortStates)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetInstancePortStatesResponse.wrap)
      .provideEnvironment(r)
    def deleteDisk(
        request: DeleteDiskRequest
    ): IO[AwsError, zio.aws.lightsail.model.DeleteDiskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest,
        DeleteDiskResponse
      ]("deleteDisk", api.deleteDisk)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.DeleteDiskResponse.wrap)
        .provideEnvironment(r)
    def updateInstanceMetadataOptions(
        request: UpdateInstanceMetadataOptionsRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateInstanceMetadataOptionsRequest,
      UpdateInstanceMetadataOptionsResponse
    ]("updateInstanceMetadataOptions", api.updateInstanceMetadataOptions)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse.wrap)
      .provideEnvironment(r)
    def getBlueprints(
        request: GetBlueprintsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetBlueprintsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest,
        GetBlueprintsResponse
      ]("getBlueprints", api.getBlueprints)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetBlueprintsResponse.wrap)
        .provideEnvironment(r)
    def deleteAlarm(request: DeleteAlarmRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest,
        DeleteAlarmResponse
      ]("deleteAlarm", api.deleteAlarm)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.DeleteAlarmResponse.wrap)
        .provideEnvironment(r)
    def createRelationalDatabaseSnapshot(
        request: CreateRelationalDatabaseSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest,
      CreateRelationalDatabaseSnapshotResponse
    ]("createRelationalDatabaseSnapshot", api.createRelationalDatabaseSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.wrap)
      .provideEnvironment(r)
    def getContainerServiceMetricData(
        request: GetContainerServiceMetricDataRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest,
      GetContainerServiceMetricDataResponse
    ]("getContainerServiceMetricData", api.getContainerServiceMetricData)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetContainerServiceMetricDataResponse.wrap)
      .provideEnvironment(r)
    def getRelationalDatabaseLogStreams(
        request: GetRelationalDatabaseLogStreamsRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest,
      GetRelationalDatabaseLogStreamsResponse
    ]("getRelationalDatabaseLogStreams", api.getRelationalDatabaseLogStreams)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.wrap)
      .provideEnvironment(r)
    def updateRelationalDatabaseParameters(
        request: UpdateRelationalDatabaseParametersRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest,
      UpdateRelationalDatabaseParametersResponse
    ](
      "updateRelationalDatabaseParameters",
      api.updateRelationalDatabaseParameters
    )(request.buildAwsValue())
      .map(
        zio.aws.lightsail.model.UpdateRelationalDatabaseParametersResponse.wrap
      )
      .provideEnvironment(r)
    def createContainerServiceDeployment(
        request: CreateContainerServiceDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest,
      CreateContainerServiceDeploymentResponse
    ]("createContainerServiceDeployment", api.createContainerServiceDeployment)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse.wrap)
      .provideEnvironment(r)
    def getDistributionLatestCacheReset(
        request: GetDistributionLatestCacheResetRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest,
      GetDistributionLatestCacheResetResponse
    ]("getDistributionLatestCacheReset", api.getDistributionLatestCacheReset)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse.wrap)
      .provideEnvironment(r)
    def updateDistributionBundle(request: UpdateDistributionBundleRequest): IO[
      AwsError,
      zio.aws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest,
      UpdateDistributionBundleResponse
    ]("updateDistributionBundle", api.updateDistributionBundle)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.UpdateDistributionBundleResponse.wrap)
      .provideEnvironment(r)
    def deleteKeyPair(
        request: DeleteKeyPairRequest
    ): IO[AwsError, zio.aws.lightsail.model.DeleteKeyPairResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest,
        DeleteKeyPairResponse
      ]("deleteKeyPair", api.deleteKeyPair)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.DeleteKeyPairResponse.wrap)
        .provideEnvironment(r)
    def updateBucketBundle(request: UpdateBucketBundleRequest): IO[
      AwsError,
      zio.aws.lightsail.model.UpdateBucketBundleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest,
      UpdateBucketBundleResponse
    ]("updateBucketBundle", api.updateBucketBundle)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.UpdateBucketBundleResponse.wrap)
      .provideEnvironment(r)
    def getStaticIps(
        request: GetStaticIpsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetStaticIpsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest,
        GetStaticIpsResponse
      ]("getStaticIps", api.getStaticIps)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetStaticIpsResponse.wrap)
        .provideEnvironment(r)
    def createRelationalDatabase(request: CreateRelationalDatabaseRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest,
      CreateRelationalDatabaseResponse
    ]("createRelationalDatabase", api.createRelationalDatabase)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateRelationalDatabaseResponse.wrap)
      .provideEnvironment(r)
    def getCertificates(
        request: GetCertificatesRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest,
        GetCertificatesResponse
      ]("getCertificates", api.getCertificates)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetCertificatesResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.lightsail.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteDomain(
        request: DeleteDomainRequest
    ): IO[AwsError, zio.aws.lightsail.model.DeleteDomainResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest,
        DeleteDomainResponse
      ]("deleteDomain", api.deleteDomain)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.DeleteDomainResponse.wrap)
        .provideEnvironment(r)
    def createBucketAccessKey(request: CreateBucketAccessKeyRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest,
      CreateBucketAccessKeyResponse
    ]("createBucketAccessKey", api.createBucketAccessKey)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateBucketAccessKeyResponse.wrap)
      .provideEnvironment(r)
    def getRelationalDatabaseSnapshots(
        request: GetRelationalDatabaseSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest,
      GetRelationalDatabaseSnapshotsResponse
    ]("getRelationalDatabaseSnapshots", api.getRelationalDatabaseSnapshots)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def createInstancesFromSnapshot(
        request: CreateInstancesFromSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest,
      CreateInstancesFromSnapshotResponse
    ]("createInstancesFromSnapshot", api.createInstancesFromSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.CreateInstancesFromSnapshotResponse.wrap)
      .provideEnvironment(r)
    def exportSnapshot(
        request: ExportSnapshotRequest
    ): IO[AwsError, zio.aws.lightsail.model.ExportSnapshotResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest,
        ExportSnapshotResponse
      ]("exportSnapshot", api.exportSnapshot)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.ExportSnapshotResponse.wrap)
        .provideEnvironment(r)
    def attachDisk(
        request: AttachDiskRequest
    ): IO[AwsError, zio.aws.lightsail.model.AttachDiskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.AttachDiskRequest,
        AttachDiskResponse
      ]("attachDisk", api.attachDisk)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.AttachDiskResponse.wrap)
        .provideEnvironment(r)
    def setIpAddressType(
        request: SetIpAddressTypeRequest
    ): IO[AwsError, zio.aws.lightsail.model.SetIpAddressTypeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest,
        SetIpAddressTypeResponse
      ]("setIpAddressType", api.setIpAddressType)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.SetIpAddressTypeResponse.wrap)
        .provideEnvironment(r)
    def getRegions(
        request: GetRegionsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetRegionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetRegionsRequest,
        GetRegionsResponse
      ]("getRegions", api.getRegions)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetRegionsResponse.wrap)
        .provideEnvironment(r)
    def getRelationalDatabaseMetricData(
        request: GetRelationalDatabaseMetricDataRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest,
      GetRelationalDatabaseMetricDataResponse
    ]("getRelationalDatabaseMetricData", api.getRelationalDatabaseMetricData)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseMetricDataResponse.wrap)
      .provideEnvironment(r)
    def getOperation(
        request: GetOperationRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetOperationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetOperationRequest,
        GetOperationResponse
      ]("getOperation", api.getOperation)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetOperationResponse.wrap)
        .provideEnvironment(r)
    def stopInstance(
        request: StopInstanceRequest
    ): IO[AwsError, zio.aws.lightsail.model.StopInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.StopInstanceRequest,
        StopInstanceResponse
      ]("stopInstance", api.stopInstance)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.StopInstanceResponse.wrap)
        .provideEnvironment(r)
    def getDistributionMetricData(
        request: GetDistributionMetricDataRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest,
      GetDistributionMetricDataResponse
    ]("getDistributionMetricData", api.getDistributionMetricData)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetDistributionMetricDataResponse.wrap)
      .provideEnvironment(r)
    def getKeyPairs(
        request: GetKeyPairsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetKeyPairsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest,
        GetKeyPairsResponse
      ]("getKeyPairs", api.getKeyPairs)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetKeyPairsResponse.wrap)
        .provideEnvironment(r)
    def disableAddOn(
        request: DisableAddOnRequest
    ): IO[AwsError, zio.aws.lightsail.model.DisableAddOnResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest,
        DisableAddOnResponse
      ]("disableAddOn", api.disableAddOn)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.DisableAddOnResponse.wrap)
        .provideEnvironment(r)
    def createInstances(
        request: CreateInstancesRequest
    ): IO[AwsError, zio.aws.lightsail.model.CreateInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest,
        CreateInstancesResponse
      ]("createInstances", api.createInstances)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.CreateInstancesResponse.wrap)
        .provideEnvironment(r)
    def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest,
      CreateLoadBalancerResponse
    ]("createLoadBalancer", api.createLoadBalancer)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.CreateLoadBalancerResponse.wrap)
      .provideEnvironment(r)
    def getRelationalDatabaseBlueprints(
        request: GetRelationalDatabaseBlueprintsRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest,
      GetRelationalDatabaseBlueprintsResponse
    ]("getRelationalDatabaseBlueprints", api.getRelationalDatabaseBlueprints)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.wrap)
      .provideEnvironment(r)
    def stopGUISession(
        request: StopGuiSessionRequest
    ): IO[AwsError, zio.aws.lightsail.model.StopGuiSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.StopGuiSessionRequest,
        StopGuiSessionResponse
      ]("stopGUISession", api.stopGUISession)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.StopGuiSessionResponse.wrap)
        .provideEnvironment(r)
    def detachCertificateFromDistribution(
        request: DetachCertificateFromDistributionRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest,
      DetachCertificateFromDistributionResponse
    ](
      "detachCertificateFromDistribution",
      api.detachCertificateFromDistribution
    )(request.buildAwsValue())
      .map(
        zio.aws.lightsail.model.DetachCertificateFromDistributionResponse.wrap
      )
      .provideEnvironment(r)
    def getRelationalDatabaseMasterUserPassword(
        request: GetRelationalDatabaseMasterUserPasswordRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest,
      GetRelationalDatabaseMasterUserPasswordResponse
    ](
      "getRelationalDatabaseMasterUserPassword",
      api.getRelationalDatabaseMasterUserPassword
    )(request.buildAwsValue())
      .map(
        zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.wrap
      )
      .provideEnvironment(r)
    def updateContainerService(request: UpdateContainerServiceRequest): IO[
      AwsError,
      zio.aws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest,
      UpdateContainerServiceResponse
    ]("updateContainerService", api.updateContainerService)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.UpdateContainerServiceResponse.wrap)
      .provideEnvironment(r)
    def getContainerServicePowers(
        request: GetContainerServicePowersRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersRequest,
      GetContainerServicePowersResponse
    ]("getContainerServicePowers", api.getContainerServicePowers)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetContainerServicePowersResponse.wrap)
      .provideEnvironment(r)
    def getRelationalDatabase(request: GetRelationalDatabaseRequest): IO[
      AwsError,
      zio.aws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest,
      GetRelationalDatabaseResponse
    ]("getRelationalDatabase", api.getRelationalDatabase)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetRelationalDatabaseResponse.wrap)
      .provideEnvironment(r)
    def getBuckets(
        request: GetBucketsRequest
    ): IO[AwsError, zio.aws.lightsail.model.GetBucketsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.lightsail.model.GetBucketsRequest,
        GetBucketsResponse
      ]("getBuckets", api.getBuckets)(request.buildAwsValue())
        .map(zio.aws.lightsail.model.GetBucketsResponse.wrap)
        .provideEnvironment(r)
    def getCloudFormationStackRecords(
        request: GetCloudFormationStackRecordsRequest
    ): IO[
      AwsError,
      zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest,
      GetCloudFormationStackRecordsResponse
    ]("getCloudFormationStackRecords", api.getCloudFormationStackRecords)(
      request.buildAwsValue()
    ).map(zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse.wrap)
      .provideEnvironment(r)
    def updateDistribution(request: UpdateDistributionRequest): IO[
      AwsError,
      zio.aws.lightsail.model.UpdateDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest,
      UpdateDistributionResponse
    ]("updateDistribution", api.updateDistribution)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.UpdateDistributionResponse.wrap)
      .provideEnvironment(r)
    def deleteDistribution(request: DeleteDistributionRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest,
      DeleteDistributionResponse
    ]("deleteDistribution", api.deleteDistribution)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.DeleteDistributionResponse.wrap)
      .provideEnvironment(r)
    def deleteContainerImage(request: DeleteContainerImageRequest): IO[
      AwsError,
      zio.aws.lightsail.model.DeleteContainerImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest,
      DeleteContainerImageResponse
    ]("deleteContainerImage", api.deleteContainerImage)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.DeleteContainerImageResponse.wrap)
      .provideEnvironment(r)
    def createDistribution(request: CreateDistributionRequest): IO[
      AwsError,
      zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest,
      CreateDistributionResponse
    ]("createDistribution", api.createDistribution)(request.buildAwsValue())
      .map(zio.aws.lightsail.model.CreateDistributionResponse.wrap)
      .provideEnvironment(r)
  }
  def putInstancePublicPorts(request: PutInstancePublicPortsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putInstancePublicPorts(request))
  def resetDistributionCache(request: ResetDistributionCacheRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.ResetDistributionCacheResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetDistributionCache(request))
  def getRelationalDatabaseSnapshot(
      request: GetRelationalDatabaseSnapshotRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseSnapshot(request))
  def getKeyPair(request: GetKeyPairRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKeyPair(request))
  def getInstanceAccessDetails(request: GetInstanceAccessDetailsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstanceAccessDetails(request))
  def deleteLoadBalancerTlsCertificate(
      request: DeleteLoadBalancerTlsCertificateRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteLoadBalancerTlsCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLoadBalancerTlsCertificate(request))
  def createDiskSnapshot(request: CreateDiskSnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateDiskSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDiskSnapshot(request))
  def deleteRelationalDatabase(request: DeleteRelationalDatabaseRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteRelationalDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRelationalDatabase(request))
  def releaseStaticIp(request: ReleaseStaticIpRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.ReleaseStaticIpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.releaseStaticIp(request))
  def updateLoadBalancerAttribute(
      request: UpdateLoadBalancerAttributeRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateLoadBalancerAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLoadBalancerAttribute(request))
  def testAlarm(request: TestAlarmRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.TestAlarmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testAlarm(request))
  def closeInstancePublicPorts(request: CloseInstancePublicPortsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CloseInstancePublicPortsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.closeInstancePublicPorts(request))
  def getSetupHistory(request: GetSetupHistoryRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetSetupHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSetupHistory(request))
  def deleteContactMethod(request: DeleteContactMethodRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteContactMethodResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContactMethod(request))
  def deleteDiskSnapshot(request: DeleteDiskSnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteDiskSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDiskSnapshot(request))
  def putAlarm(request: PutAlarmRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.PutAlarmResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAlarm(request))
  def getInstances(request: GetInstancesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstances(request))
  def createCertificate(request: CreateCertificateRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCertificate(request))
  def getRelationalDatabaseLogEvents(
      request: GetRelationalDatabaseLogEventsRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseLogEvents(request))
  def deleteKnownHostKeys(request: DeleteKnownHostKeysRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteKnownHostKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKnownHostKeys(request))
  def rebootRelationalDatabase(request: RebootRelationalDatabaseRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.RebootRelationalDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootRelationalDatabase(request))
  def createCloudFormationStack(request: CreateCloudFormationStackRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateCloudFormationStackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCloudFormationStack(request))
  def getBucketMetricData(request: GetBucketMetricDataRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetBucketMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketMetricData(request))
  def detachDisk(request: DetachDiskRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DetachDiskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachDisk(request))
  def allocateStaticIp(request: AllocateStaticIpRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.AllocateStaticIpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.allocateStaticIp(request))
  def getRelationalDatabaseEvents(
      request: GetRelationalDatabaseEventsRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseEvents(request))
  def getOperations(request: GetOperationsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetOperationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOperations(request))
  def setupInstanceHttps(request: SetupInstanceHttpsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.SetupInstanceHttpsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setupInstanceHttps(request))
  def getInstanceState(request: GetInstanceStateRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetInstanceStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstanceState(request))
  def getDomains(request: GetDomainsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomains(request))
  def getLoadBalancers(request: GetLoadBalancersRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetLoadBalancersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoadBalancers(request))
  def getContainerServices(request: GetContainerServicesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetContainerServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerServices(request))
  def getLoadBalancerTlsCertificates(
      request: GetLoadBalancerTlsCertificatesRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetLoadBalancerTlsCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoadBalancerTlsCertificates(request))
  def createRelationalDatabaseFromSnapshot(
      request: CreateRelationalDatabaseFromSnapshotRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRelationalDatabaseFromSnapshot(request))
  def getInstanceSnapshot(request: GetInstanceSnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetInstanceSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstanceSnapshot(request))
  def deleteContainerService(request: DeleteContainerServiceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteContainerServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContainerService(request))
  def getContainerAPIMetadata(request: GetContainerApiMetadataRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerAPIMetadata(request))
  def getDiskSnapshot(request: GetDiskSnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDiskSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDiskSnapshot(request))
  def createGUISessionAccessDetails(
      request: CreateGuiSessionAccessDetailsRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGUISessionAccessDetails(request))
  def detachStaticIp(request: DetachStaticIpRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DetachStaticIpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachStaticIp(request))
  def createDisk(request: CreateDiskRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateDiskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDisk(request))
  def getContainerImages(request: GetContainerImagesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetContainerImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerImages(request))
  def deleteBucketAccessKey(request: DeleteBucketAccessKeyRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteBucketAccessKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBucketAccessKey(request))
  def createDomainEntry(request: CreateDomainEntryRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateDomainEntryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomainEntry(request))
  def getCostEstimate(request: GetCostEstimateRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetCostEstimateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCostEstimate(request))
  def sendContactMethodVerification(
      request: SendContactMethodVerificationRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.SendContactMethodVerificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendContactMethodVerification(request))
  def getDomain(request: GetDomainRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomain(request))
  def deleteInstance(request: DeleteInstanceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInstance(request))
  def copySnapshot(request: CopySnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CopySnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copySnapshot(request))
  def getContactMethods(request: GetContactMethodsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetContactMethodsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContactMethods(request))
  def getRelationalDatabaseBundles(
      request: GetRelationalDatabaseBundlesRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseBundles(request))
  def detachInstancesFromLoadBalancer(
      request: DetachInstancesFromLoadBalancerRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DetachInstancesFromLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachInstancesFromLoadBalancer(request))
  def openInstancePublicPorts(request: OpenInstancePublicPortsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.openInstancePublicPorts(request))
  def getInstanceMetricData(request: GetInstanceMetricDataRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetInstanceMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstanceMetricData(request))
  def deleteRelationalDatabaseSnapshot(
      request: DeleteRelationalDatabaseSnapshotRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteRelationalDatabaseSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRelationalDatabaseSnapshot(request))
  def attachInstancesToLoadBalancer(
      request: AttachInstancesToLoadBalancerRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.AttachInstancesToLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachInstancesToLoadBalancer(request))
  def getDistributionBundles(request: GetDistributionBundlesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDistributionBundlesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDistributionBundles(request))
  def getRelationalDatabaseParameters(
      request: GetRelationalDatabaseParametersRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseParameters(request))
  def getAlarms(request: GetAlarmsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetAlarmsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAlarms(request))
  def deleteLoadBalancer(request: DeleteLoadBalancerRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLoadBalancer(request))
  def getInstanceSnapshots(request: GetInstanceSnapshotsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetInstanceSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstanceSnapshots(request))
  def stopRelationalDatabase(request: StopRelationalDatabaseRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.StopRelationalDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopRelationalDatabase(request))
  def getLoadBalancerMetricData(request: GetLoadBalancerMetricDataRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetLoadBalancerMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoadBalancerMetricData(request))
  def attachCertificateToDistribution(
      request: AttachCertificateToDistributionRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.AttachCertificateToDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachCertificateToDistribution(request))
  def deleteCertificate(request: DeleteCertificateRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCertificate(request))
  def startGUISession(request: StartGuiSessionRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.StartGuiSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startGUISession(request))
  def getInstance(request: GetInstanceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstance(request))
  def getDistributions(request: GetDistributionsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDistributionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDistributions(request))
  def getRelationalDatabases(request: GetRelationalDatabasesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabases(request))
  def attachLoadBalancerTlsCertificate(
      request: AttachLoadBalancerTlsCertificateRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachLoadBalancerTlsCertificate(request))
  def getOperationsForResource(request: GetOperationsForResourceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetOperationsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOperationsForResource(request))
  def createDiskFromSnapshot(request: CreateDiskFromSnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateDiskFromSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDiskFromSnapshot(request))
  def getLoadBalancer(request: GetLoadBalancerRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoadBalancer(request))
  def getBucketBundles(request: GetBucketBundlesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetBucketBundlesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketBundles(request))
  def deleteInstanceSnapshot(request: DeleteInstanceSnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteInstanceSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInstanceSnapshot(request))
  def deleteDomainEntry(request: DeleteDomainEntryRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteDomainEntryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDomainEntry(request))
  def updateRelationalDatabase(request: UpdateRelationalDatabaseRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateRelationalDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRelationalDatabase(request))
  def peerVpc(request: PeerVpcRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.PeerVpcResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.peerVpc(request))
  def unpeerVpc(request: UnpeerVpcRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UnpeerVpcResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.unpeerVpc(request))
  def getActiveNames(request: GetActiveNamesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetActiveNamesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getActiveNames(request))
  def deleteBucket(request: DeleteBucketRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteBucketResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBucket(request))
  def getAutoSnapshots(request: GetAutoSnapshotsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAutoSnapshots(request))
  def startRelationalDatabase(request: StartRelationalDatabaseRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.StartRelationalDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startRelationalDatabase(request))
  def createInstanceSnapshot(request: CreateInstanceSnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateInstanceSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInstanceSnapshot(request))
  def updateDomainEntry(request: UpdateDomainEntryRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateDomainEntryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDomainEntry(request))
  def updateBucket(request: UpdateBucketRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateBucketResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBucket(request))
  def rebootInstance(request: RebootInstanceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.RebootInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootInstance(request))
  def createContactMethod(request: CreateContactMethodRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateContactMethodResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContactMethod(request))
  def getDiskSnapshots(request: GetDiskSnapshotsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDiskSnapshots(request))
  def createBucket(request: CreateBucketRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateBucketResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBucket(request))
  def getContainerLog(request: GetContainerLogRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetContainerLogResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerLog(request))
  def getContainerServiceDeployments(
      request: GetContainerServiceDeploymentsRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerServiceDeployments(request))
  def createDomain(request: CreateDomainRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomain(request))
  def setResourceAccessForBucket(
      request: SetResourceAccessForBucketRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.SetResourceAccessForBucketResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setResourceAccessForBucket(request))
  def getBucketAccessKeys(request: GetBucketAccessKeysRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBucketAccessKeys(request))
  def createContainerService(request: CreateContainerServiceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateContainerServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContainerService(request))
  def isVpcPeered(request: IsVpcPeeredRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.IsVpcPeeredResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.isVpcPeered(request))
  def deleteAutoSnapshot(request: DeleteAutoSnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteAutoSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAutoSnapshot(request))
  def createContainerServiceRegistryLogin(
      request: CreateContainerServiceRegistryLoginRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContainerServiceRegistryLogin(request))
  def getDisk(request: GetDiskRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDiskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDisk(request))
  def enableAddOn(request: EnableAddOnRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.EnableAddOnResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableAddOn(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createLoadBalancerTlsCertificate(
      request: CreateLoadBalancerTlsCertificateRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateLoadBalancerTlsCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLoadBalancerTlsCertificate(request))
  def getStaticIp(request: GetStaticIpRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetStaticIpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStaticIp(request))
  def attachStaticIp(request: AttachStaticIpRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.AttachStaticIpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachStaticIp(request))
  def importKeyPair(request: ImportKeyPairRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.ImportKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importKeyPair(request))
  def getDisks(request: GetDisksRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDisksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDisks(request))
  def downloadDefaultKeyPair(request: DownloadDefaultKeyPairRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.downloadDefaultKeyPair(request))
  def getExportSnapshotRecords(request: GetExportSnapshotRecordsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetExportSnapshotRecordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExportSnapshotRecords(request))
  def createKeyPair(request: CreateKeyPairRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKeyPair(request))
  def getLoadBalancerTlsPolicies(
      request: GetLoadBalancerTlsPoliciesRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetLoadBalancerTlsPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoadBalancerTlsPolicies(request))
  def getBundles(request: GetBundlesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetBundlesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBundles(request))
  def registerContainerImage(request: RegisterContainerImageRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerContainerImage(request))
  def startInstance(request: StartInstanceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.StartInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startInstance(request))
  def getInstancePortStates(request: GetInstancePortStatesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetInstancePortStatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstancePortStates(request))
  def deleteDisk(request: DeleteDiskRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteDiskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDisk(request))
  def updateInstanceMetadataOptions(
      request: UpdateInstanceMetadataOptionsRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateInstanceMetadataOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateInstanceMetadataOptions(request))
  def getBlueprints(request: GetBlueprintsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetBlueprintsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBlueprints(request))
  def deleteAlarm(
      request: DeleteAlarmRequest
  ): ZIO[zio.aws.lightsail.Lightsail, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteAlarm(request))
  def createRelationalDatabaseSnapshot(
      request: CreateRelationalDatabaseSnapshotRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateRelationalDatabaseSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRelationalDatabaseSnapshot(request))
  def getContainerServiceMetricData(
      request: GetContainerServiceMetricDataRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerServiceMetricData(request))
  def getRelationalDatabaseLogStreams(
      request: GetRelationalDatabaseLogStreamsRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseLogStreams(request))
  def updateRelationalDatabaseParameters(
      request: UpdateRelationalDatabaseParametersRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateRelationalDatabaseParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRelationalDatabaseParameters(request))
  def createContainerServiceDeployment(
      request: CreateContainerServiceDeploymentRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContainerServiceDeployment(request))
  def getDistributionLatestCacheReset(
      request: GetDistributionLatestCacheResetRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDistributionLatestCacheReset(request))
  def updateDistributionBundle(request: UpdateDistributionBundleRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateDistributionBundleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDistributionBundle(request))
  def deleteKeyPair(request: DeleteKeyPairRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKeyPair(request))
  def updateBucketBundle(request: UpdateBucketBundleRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateBucketBundleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBucketBundle(request))
  def getStaticIps(request: GetStaticIpsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetStaticIpsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStaticIps(request))
  def createRelationalDatabase(request: CreateRelationalDatabaseRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateRelationalDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRelationalDatabase(request))
  def getCertificates(request: GetCertificatesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCertificates(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteDomain(request: DeleteDomainRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDomain(request))
  def createBucketAccessKey(request: CreateBucketAccessKeyRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateBucketAccessKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBucketAccessKey(request))
  def getRelationalDatabaseSnapshots(
      request: GetRelationalDatabaseSnapshotsRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseSnapshots(request))
  def createInstancesFromSnapshot(
      request: CreateInstancesFromSnapshotRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateInstancesFromSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInstancesFromSnapshot(request))
  def exportSnapshot(request: ExportSnapshotRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.ExportSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportSnapshot(request))
  def attachDisk(request: AttachDiskRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.AttachDiskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachDisk(request))
  def setIpAddressType(request: SetIpAddressTypeRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.SetIpAddressTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setIpAddressType(request))
  def getRegions(request: GetRegionsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRegionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRegions(request))
  def getRelationalDatabaseMetricData(
      request: GetRelationalDatabaseMetricDataRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseMetricData(request))
  def getOperation(request: GetOperationRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetOperationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOperation(request))
  def stopInstance(request: StopInstanceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.StopInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopInstance(request))
  def getDistributionMetricData(request: GetDistributionMetricDataRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetDistributionMetricDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDistributionMetricData(request))
  def getKeyPairs(request: GetKeyPairsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetKeyPairsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKeyPairs(request))
  def disableAddOn(request: DisableAddOnRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DisableAddOnResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableAddOn(request))
  def createInstances(request: CreateInstancesRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInstances(request))
  def createLoadBalancer(request: CreateLoadBalancerRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLoadBalancer(request))
  def getRelationalDatabaseBlueprints(
      request: GetRelationalDatabaseBlueprintsRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseBlueprints(request))
  def stopGUISession(request: StopGuiSessionRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.StopGuiSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopGUISession(request))
  def detachCertificateFromDistribution(
      request: DetachCertificateFromDistributionRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DetachCertificateFromDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachCertificateFromDistribution(request))
  def getRelationalDatabaseMasterUserPassword(
      request: GetRelationalDatabaseMasterUserPasswordRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabaseMasterUserPassword(request))
  def updateContainerService(request: UpdateContainerServiceRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateContainerServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContainerService(request))
  def getContainerServicePowers(request: GetContainerServicePowersRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetContainerServicePowersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerServicePowers(request))
  def getRelationalDatabase(request: GetRelationalDatabaseRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetRelationalDatabaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRelationalDatabase(request))
  def getBuckets(request: GetBucketsRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetBucketsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBuckets(request))
  def getCloudFormationStackRecords(
      request: GetCloudFormationStackRecordsRequest
  ): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCloudFormationStackRecords(request))
  def updateDistribution(request: UpdateDistributionRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.UpdateDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDistribution(request))
  def deleteDistribution(request: DeleteDistributionRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDistribution(request))
  def deleteContainerImage(request: DeleteContainerImageRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.DeleteContainerImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContainerImage(request))
  def createDistribution(request: CreateDistributionRequest): ZIO[
    zio.aws.lightsail.Lightsail,
    AwsError,
    zio.aws.lightsail.model.CreateDistributionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDistribution(request))
}
