package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.IsoDate
import scala.jdk.CollectionConverters._
final case class AccountLevelBpaSync(
    status: Optional[zio.aws.lightsail.model.AccountLevelBpaSyncStatus] =
      Optional.Absent,
    lastSyncedAt: Optional[IsoDate] = Optional.Absent,
    message: Optional[zio.aws.lightsail.model.BPAStatusMessage] =
      Optional.Absent,
    bpaImpactsLightsail: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSync = {
    import AccountLevelBpaSync.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSync
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastSyncedAt.map(value => IsoDate.unwrap(value): Instant)
      )(_.lastSyncedAt)
      .optionallyWith(message.map(value => value.unwrap))(_.message)
      .optionallyWith(
        bpaImpactsLightsail.map(value => value: java.lang.Boolean)
      )(_.bpaImpactsLightsail)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AccountLevelBpaSync.ReadOnly =
    zio.aws.lightsail.model.AccountLevelBpaSync.wrap(buildAwsValue())
}
object AccountLevelBpaSync {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSync
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AccountLevelBpaSync =
      zio.aws.lightsail.model.AccountLevelBpaSync(
        status.map(value => value),
        lastSyncedAt.map(value => value),
        message.map(value => value),
        bpaImpactsLightsail.map(value => value)
      )
    def status: Optional[zio.aws.lightsail.model.AccountLevelBpaSyncStatus]
    def lastSyncedAt: Optional[IsoDate]
    def message: Optional[zio.aws.lightsail.model.BPAStatusMessage]
    def bpaImpactsLightsail: Optional[Boolean]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.AccountLevelBpaSyncStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getLastSyncedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("lastSyncedAt", lastSyncedAt)
    def getMessage
        : ZIO[Any, AwsError, zio.aws.lightsail.model.BPAStatusMessage] =
      AwsError.unwrapOptionField("message", message)
    def getBpaImpactsLightsail: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("bpaImpactsLightsail", bpaImpactsLightsail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSync
  ) extends zio.aws.lightsail.model.AccountLevelBpaSync.ReadOnly {
    override val status
        : Optional[zio.aws.lightsail.model.AccountLevelBpaSyncStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.lightsail.model.AccountLevelBpaSyncStatus.wrap(value)
        )
    override val lastSyncedAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSyncedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val message: Optional[zio.aws.lightsail.model.BPAStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value => zio.aws.lightsail.model.BPAStatusMessage.wrap(value))
    override val bpaImpactsLightsail: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.bpaImpactsLightsail())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AccountLevelBpaSync
  ): zio.aws.lightsail.model.AccountLevelBpaSync.ReadOnly = new Wrapper(impl)
}
