package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddOnRequest(
    addOnType: zio.aws.lightsail.model.AddOnType,
    autoSnapshotAddOnRequest: Optional[
      zio.aws.lightsail.model.AutoSnapshotAddOnRequest
    ] = Optional.Absent,
    stopInstanceOnIdleRequest: Optional[
      zio.aws.lightsail.model.StopInstanceOnIdleRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AddOnRequest = {
    import AddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AddOnRequest
      .builder()
      .addOnType(addOnType.unwrap)
      .optionallyWith(
        autoSnapshotAddOnRequest.map(value => value.buildAwsValue())
      )(_.autoSnapshotAddOnRequest)
      .optionallyWith(
        stopInstanceOnIdleRequest.map(value => value.buildAwsValue())
      )(_.stopInstanceOnIdleRequest)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.AddOnRequest.ReadOnly =
    zio.aws.lightsail.model.AddOnRequest.wrap(buildAwsValue())
}
object AddOnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AddOnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.AddOnRequest =
      zio.aws.lightsail.model.AddOnRequest(
        addOnType,
        autoSnapshotAddOnRequest.map(value => value.asEditable),
        stopInstanceOnIdleRequest.map(value => value.asEditable)
      )
    def addOnType: zio.aws.lightsail.model.AddOnType
    def autoSnapshotAddOnRequest
        : Optional[zio.aws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly]
    def stopInstanceOnIdleRequest
        : Optional[zio.aws.lightsail.model.StopInstanceOnIdleRequest.ReadOnly]
    def getAddOnType: ZIO[Any, Nothing, zio.aws.lightsail.model.AddOnType] =
      ZIO.succeed(addOnType)
    def getAutoSnapshotAddOnRequest: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoSnapshotAddOnRequest",
      autoSnapshotAddOnRequest
    )
    def getStopInstanceOnIdleRequest: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.StopInstanceOnIdleRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "stopInstanceOnIdleRequest",
      stopInstanceOnIdleRequest
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AddOnRequest
  ) extends zio.aws.lightsail.model.AddOnRequest.ReadOnly {
    override val addOnType: zio.aws.lightsail.model.AddOnType =
      zio.aws.lightsail.model.AddOnType.wrap(impl.addOnType())
    override val autoSnapshotAddOnRequest
        : Optional[zio.aws.lightsail.model.AutoSnapshotAddOnRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoSnapshotAddOnRequest())
        .map(value =>
          zio.aws.lightsail.model.AutoSnapshotAddOnRequest.wrap(value)
        )
    override val stopInstanceOnIdleRequest
        : Optional[zio.aws.lightsail.model.StopInstanceOnIdleRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stopInstanceOnIdleRequest())
        .map(value =>
          zio.aws.lightsail.model.StopInstanceOnIdleRequest.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AddOnRequest
  ): zio.aws.lightsail.model.AddOnRequest.ReadOnly = new Wrapper(impl)
}
