package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  Integer,
  MetricPeriod,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class Alarm(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    monitoredResourceInfo: Optional[
      zio.aws.lightsail.model.MonitoredResourceInfo
    ] = Optional.Absent,
    comparisonOperator: Optional[zio.aws.lightsail.model.ComparisonOperator] =
      Optional.Absent,
    evaluationPeriods: Optional[Integer] = Optional.Absent,
    period: Optional[MetricPeriod] = Optional.Absent,
    threshold: Optional[Double] = Optional.Absent,
    datapointsToAlarm: Optional[Integer] = Optional.Absent,
    treatMissingData: Optional[zio.aws.lightsail.model.TreatMissingData] =
      Optional.Absent,
    statistic: Optional[zio.aws.lightsail.model.MetricStatistic] =
      Optional.Absent,
    metricName: Optional[zio.aws.lightsail.model.MetricName] = Optional.Absent,
    state: Optional[zio.aws.lightsail.model.AlarmState] = Optional.Absent,
    unit: Optional[zio.aws.lightsail.model.MetricUnit] = Optional.Absent,
    contactProtocols: Optional[
      Iterable[zio.aws.lightsail.model.ContactProtocol]
    ] = Optional.Absent,
    notificationTriggers: Optional[
      Iterable[zio.aws.lightsail.model.AlarmState]
    ] = Optional.Absent,
    notificationEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Alarm = {
    import Alarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Alarm
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(
        monitoredResourceInfo.map(value => value.buildAwsValue())
      )(_.monitoredResourceInfo)
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(evaluationPeriods.map(value => value: java.lang.Integer))(
        _.evaluationPeriods
      )
      .optionallyWith(
        period.map(value => MetricPeriod.unwrap(value): java.lang.Integer)
      )(_.period)
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .optionallyWith(datapointsToAlarm.map(value => value: java.lang.Integer))(
        _.datapointsToAlarm
      )
      .optionallyWith(treatMissingData.map(value => value.unwrap))(
        _.treatMissingData
      )
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        contactProtocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contactProtocolsWithStrings)
      .optionallyWith(
        notificationTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationTriggersWithStrings)
      .optionallyWith(
        notificationEnabled.map(value => value: java.lang.Boolean)
      )(_.notificationEnabled)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Alarm.ReadOnly =
    zio.aws.lightsail.model.Alarm.wrap(buildAwsValue())
}
object Alarm {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Alarm] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Alarm =
      zio.aws.lightsail.model.Alarm(
        name.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        supportCode.map(value => value),
        monitoredResourceInfo.map(value => value.asEditable),
        comparisonOperator.map(value => value),
        evaluationPeriods.map(value => value),
        period.map(value => value),
        threshold.map(value => value),
        datapointsToAlarm.map(value => value),
        treatMissingData.map(value => value),
        statistic.map(value => value),
        metricName.map(value => value),
        state.map(value => value),
        unit.map(value => value),
        contactProtocols.map(value => value),
        notificationTriggers.map(value => value),
        notificationEnabled.map(value => value)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def supportCode: Optional[String]
    def monitoredResourceInfo
        : Optional[zio.aws.lightsail.model.MonitoredResourceInfo.ReadOnly]
    def comparisonOperator: Optional[zio.aws.lightsail.model.ComparisonOperator]
    def evaluationPeriods: Optional[Integer]
    def period: Optional[MetricPeriod]
    def threshold: Optional[Double]
    def datapointsToAlarm: Optional[Integer]
    def treatMissingData: Optional[zio.aws.lightsail.model.TreatMissingData]
    def statistic: Optional[zio.aws.lightsail.model.MetricStatistic]
    def metricName: Optional[zio.aws.lightsail.model.MetricName]
    def state: Optional[zio.aws.lightsail.model.AlarmState]
    def unit: Optional[zio.aws.lightsail.model.MetricUnit]
    def contactProtocols
        : Optional[List[zio.aws.lightsail.model.ContactProtocol]]
    def notificationTriggers: Optional[List[zio.aws.lightsail.model.AlarmState]]
    def notificationEnabled: Optional[Boolean]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getMonitoredResourceInfo: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.MonitoredResourceInfo.ReadOnly
    ] =
      AwsError.unwrapOptionField("monitoredResourceInfo", monitoredResourceInfo)
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ComparisonOperator] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getEvaluationPeriods: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriods)
    def getPeriod: ZIO[Any, AwsError, MetricPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getThreshold: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getDatapointsToAlarm: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarm)
    def getTreatMissingData
        : ZIO[Any, AwsError, zio.aws.lightsail.model.TreatMissingData] =
      AwsError.unwrapOptionField("treatMissingData", treatMissingData)
    def getStatistic
        : ZIO[Any, AwsError, zio.aws.lightsail.model.MetricStatistic] =
      AwsError.unwrapOptionField("statistic", statistic)
    def getMetricName: ZIO[Any, AwsError, zio.aws.lightsail.model.MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getState: ZIO[Any, AwsError, zio.aws.lightsail.model.AlarmState] =
      AwsError.unwrapOptionField("state", state)
    def getUnit: ZIO[Any, AwsError, zio.aws.lightsail.model.MetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getContactProtocols
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.ContactProtocol]] =
      AwsError.unwrapOptionField("contactProtocols", contactProtocols)
    def getNotificationTriggers
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.AlarmState]] =
      AwsError.unwrapOptionField("notificationTriggers", notificationTriggers)
    def getNotificationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("notificationEnabled", notificationEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Alarm
  ) extends zio.aws.lightsail.model.Alarm.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val monitoredResourceInfo
        : Optional[zio.aws.lightsail.model.MonitoredResourceInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoredResourceInfo())
        .map(value => zio.aws.lightsail.model.MonitoredResourceInfo.wrap(value))
    override val comparisonOperator
        : Optional[zio.aws.lightsail.model.ComparisonOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparisonOperator())
        .map(value => zio.aws.lightsail.model.ComparisonOperator.wrap(value))
    override val evaluationPeriods: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationPeriods())
      .map(value => value: Integer)
    override val period: Optional[MetricPeriod] = zio.aws.core.internal
      .optionalFromNullable(impl.period())
      .map(value => zio.aws.lightsail.model.primitives.MetricPeriod(value))
    override val threshold: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.threshold())
      .map(value => value: Double)
    override val datapointsToAlarm: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.datapointsToAlarm())
      .map(value => value: Integer)
    override val treatMissingData
        : Optional[zio.aws.lightsail.model.TreatMissingData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatMissingData())
        .map(value => zio.aws.lightsail.model.TreatMissingData.wrap(value))
    override val statistic: Optional[zio.aws.lightsail.model.MetricStatistic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.lightsail.model.MetricStatistic.wrap(value))
    override val metricName: Optional[zio.aws.lightsail.model.MetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricName())
        .map(value => zio.aws.lightsail.model.MetricName.wrap(value))
    override val state: Optional[zio.aws.lightsail.model.AlarmState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.AlarmState.wrap(value))
    override val unit: Optional[zio.aws.lightsail.model.MetricUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.lightsail.model.MetricUnit.wrap(value))
    override val contactProtocols
        : Optional[List[zio.aws.lightsail.model.ContactProtocol]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactProtocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.ContactProtocol.wrap(item)
          }.toList
        )
    override val notificationTriggers
        : Optional[List[zio.aws.lightsail.model.AlarmState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationTriggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AlarmState.wrap(item)
          }.toList
        )
    override val notificationEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.notificationEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Alarm
  ): zio.aws.lightsail.model.Alarm.ReadOnly = new Wrapper(impl)
}
