package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait AppCategory {
  def unwrap: software.amazon.awssdk.services.lightsail.model.AppCategory
}
object AppCategory {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.AppCategory
  ): zio.aws.lightsail.model.AppCategory = value match {
    case software.amazon.awssdk.services.lightsail.model.AppCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AppCategory.LFR =>
      val r = LfR
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.AppCategory {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AppCategory =
      software.amazon.awssdk.services.lightsail.model.AppCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object LfR extends zio.aws.lightsail.model.AppCategory {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AppCategory =
      software.amazon.awssdk.services.lightsail.model.AppCategory.LFR
  }
}
