package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttachLoadBalancerTlsCertificateRequest(
    loadBalancerName: ResourceName,
    certificateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest = {
    import AttachLoadBalancerTlsCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest
      .builder()
      .loadBalancerName(ResourceName.unwrap(loadBalancerName): java.lang.String)
      .certificateName(ResourceName.unwrap(certificateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateRequest.ReadOnly =
    zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateRequest
      .wrap(buildAwsValue())
}
object AttachLoadBalancerTlsCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateRequest =
      zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateRequest(
        loadBalancerName,
        certificateName
      )
    def loadBalancerName: ResourceName
    def certificateName: ResourceName
    def getLoadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerName)
    def getCertificateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(certificateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest
  ) extends zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateRequest.ReadOnly {
    override val loadBalancerName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.loadBalancerName())
    override val certificateName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.certificateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest
  ): zio.aws.lightsail.model.AttachLoadBalancerTlsCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
