package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait AutoMountStatus {
  def unwrap: software.amazon.awssdk.services.lightsail.model.AutoMountStatus
}
object AutoMountStatus {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.AutoMountStatus
  ): zio.aws.lightsail.model.AutoMountStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.AutoMountStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AutoMountStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lightsail.model.AutoMountStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.lightsail.model.AutoMountStatus.MOUNTED =>
      val r = Mounted
      r
    case software.amazon.awssdk.services.lightsail.model.AutoMountStatus.NOT_MOUNTED =>
      val r = NotMounted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.AutoMountStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoMountStatus =
      software.amazon.awssdk.services.lightsail.model.AutoMountStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Failed extends zio.aws.lightsail.model.AutoMountStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoMountStatus =
      software.amazon.awssdk.services.lightsail.model.AutoMountStatus.FAILED
  }
  case object Pending extends zio.aws.lightsail.model.AutoMountStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoMountStatus =
      software.amazon.awssdk.services.lightsail.model.AutoMountStatus.PENDING
  }
  case object Mounted extends zio.aws.lightsail.model.AutoMountStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoMountStatus =
      software.amazon.awssdk.services.lightsail.model.AutoMountStatus.MOUNTED
  }
  case object NotMounted extends zio.aws.lightsail.model.AutoMountStatus {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AutoMountStatus =
      software.amazon.awssdk.services.lightsail.model.AutoMountStatus.NOT_MOUNTED
  }
}
