package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait BPAStatusMessage {
  def unwrap: software.amazon.awssdk.services.lightsail.model.BPAStatusMessage
}
object BPAStatusMessage {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.BPAStatusMessage
  ): zio.aws.lightsail.model.BPAStatusMessage = value match {
    case software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.DEFAULTED_FOR_SLR_MISSING =>
      val r = DEFAULTED_FOR_SLR_MISSING
      r
    case software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.SYNC_ON_HOLD =>
      val r = SYNC_ON_HOLD
      r
    case software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.DEFAULTED_FOR_SLR_MISSING_ON_HOLD =>
      val r = DEFAULTED_FOR_SLR_MISSING_ON_HOLD
      r
    case software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.UNKNOWN =>
      val r = Unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.BPAStatusMessage {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BPAStatusMessage =
      software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULTED_FOR_SLR_MISSING
      extends zio.aws.lightsail.model.BPAStatusMessage {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BPAStatusMessage =
      software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.DEFAULTED_FOR_SLR_MISSING
  }
  case object SYNC_ON_HOLD extends zio.aws.lightsail.model.BPAStatusMessage {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BPAStatusMessage =
      software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.SYNC_ON_HOLD
  }
  case object DEFAULTED_FOR_SLR_MISSING_ON_HOLD
      extends zio.aws.lightsail.model.BPAStatusMessage {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BPAStatusMessage =
      software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.DEFAULTED_FOR_SLR_MISSING_ON_HOLD
  }
  case object Unknown extends zio.aws.lightsail.model.BPAStatusMessage {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BPAStatusMessage =
      software.amazon.awssdk.services.lightsail.model.BPAStatusMessage.UNKNOWN
  }
}
