package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  Integer,
  ResourceName,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Blueprint(
    blueprintId: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    group: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[zio.aws.lightsail.model.BlueprintType] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    isActive: Optional[Boolean] = Optional.Absent,
    minPower: Optional[Integer] = Optional.Absent,
    version: Optional[String] = Optional.Absent,
    versionCode: Optional[String] = Optional.Absent,
    productUrl: Optional[String] = Optional.Absent,
    licenseUrl: Optional[String] = Optional.Absent,
    platform: Optional[zio.aws.lightsail.model.InstancePlatform] =
      Optional.Absent,
    appCategory: Optional[zio.aws.lightsail.model.AppCategory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Blueprint = {
    import Blueprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Blueprint
      .builder()
      .optionallyWith(
        blueprintId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.blueprintId)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        group.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.group)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .optionallyWith(minPower.map(value => value: java.lang.Integer))(
        _.minPower
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(versionCode.map(value => value: java.lang.String))(
        _.versionCode
      )
      .optionallyWith(productUrl.map(value => value: java.lang.String))(
        _.productUrl
      )
      .optionallyWith(licenseUrl.map(value => value: java.lang.String))(
        _.licenseUrl
      )
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(appCategory.map(value => value.unwrap))(_.appCategory)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Blueprint.ReadOnly =
    zio.aws.lightsail.model.Blueprint.wrap(buildAwsValue())
}
object Blueprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Blueprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Blueprint =
      zio.aws.lightsail.model.Blueprint(
        blueprintId.map(value => value),
        name.map(value => value),
        group.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        isActive.map(value => value),
        minPower.map(value => value),
        version.map(value => value),
        versionCode.map(value => value),
        productUrl.map(value => value),
        licenseUrl.map(value => value),
        platform.map(value => value),
        appCategory.map(value => value)
      )
    def blueprintId: Optional[NonEmptyString]
    def name: Optional[ResourceName]
    def group: Optional[NonEmptyString]
    def `type`: Optional[zio.aws.lightsail.model.BlueprintType]
    def description: Optional[String]
    def isActive: Optional[Boolean]
    def minPower: Optional[Integer]
    def version: Optional[String]
    def versionCode: Optional[String]
    def productUrl: Optional[String]
    def licenseUrl: Optional[String]
    def platform: Optional[zio.aws.lightsail.model.InstancePlatform]
    def appCategory: Optional[zio.aws.lightsail.model.AppCategory]
    def getBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("blueprintId", blueprintId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("group", group)
    def getType: ZIO[Any, AwsError, zio.aws.lightsail.model.BlueprintType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
    def getMinPower: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minPower", minPower)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getVersionCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionCode", versionCode)
    def getProductUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productUrl", productUrl)
    def getLicenseUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseUrl", licenseUrl)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstancePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getAppCategory
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AppCategory] =
      AwsError.unwrapOptionField("appCategory", appCategory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Blueprint
  ) extends zio.aws.lightsail.model.Blueprint.ReadOnly {
    override val blueprintId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.blueprintId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val group: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val `type`: Optional[zio.aws.lightsail.model.BlueprintType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.lightsail.model.BlueprintType.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
    override val minPower: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minPower())
      .map(value => value: Integer)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
    override val versionCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.versionCode())
      .map(value => value: String)
    override val productUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productUrl())
      .map(value => value: String)
    override val licenseUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseUrl())
      .map(value => value: String)
    override val platform: Optional[zio.aws.lightsail.model.InstancePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.lightsail.model.InstancePlatform.wrap(value))
    override val appCategory: Optional[zio.aws.lightsail.model.AppCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appCategory())
        .map(value => zio.aws.lightsail.model.AppCategory.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Blueprint
  ): zio.aws.lightsail.model.Blueprint.ReadOnly = new Wrapper(impl)
}
