package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{BucketAccessLogPrefix, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BucketAccessLogConfig(
    enabled: Boolean,
    destination: Optional[BucketName] = Optional.Absent,
    prefix: Optional[BucketAccessLogPrefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig = {
    import BucketAccessLogConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        destination.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.destination)
      .optionallyWith(
        prefix.map(value =>
          BucketAccessLogPrefix.unwrap(value): java.lang.String
        )
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly =
    zio.aws.lightsail.model.BucketAccessLogConfig.wrap(buildAwsValue())
}
object BucketAccessLogConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.BucketAccessLogConfig =
      zio.aws.lightsail.model.BucketAccessLogConfig(
        enabled,
        destination.map(value => value),
        prefix.map(value => value)
      )
    def enabled: Boolean
    def destination: Optional[BucketName]
    def prefix: Optional[BucketAccessLogPrefix]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getDestination: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("destination", destination)
    def getPrefix: ZIO[Any, AwsError, BucketAccessLogPrefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
  ) extends zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val destination: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.lightsail.model.primitives.BucketName(value))
    override val prefix: Optional[BucketAccessLogPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value =>
        zio.aws.lightsail.model.primitives.BucketAccessLogPrefix(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
  ): zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly = new Wrapper(impl)
}
