package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Integer, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BucketBundle(
    bundleId: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    price: Optional[Float] = Optional.Absent,
    storagePerMonthInGb: Optional[Integer] = Optional.Absent,
    transferPerMonthInGb: Optional[Integer] = Optional.Absent,
    isActive: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.BucketBundle = {
    import BucketBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketBundle
      .builder()
      .optionallyWith(
        bundleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(
        storagePerMonthInGb.map(value => value: java.lang.Integer)
      )(_.storagePerMonthInGb)
      .optionallyWith(
        transferPerMonthInGb.map(value => value: java.lang.Integer)
      )(_.transferPerMonthInGb)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.BucketBundle.ReadOnly =
    zio.aws.lightsail.model.BucketBundle.wrap(buildAwsValue())
}
object BucketBundle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.BucketBundle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.BucketBundle =
      zio.aws.lightsail.model.BucketBundle(
        bundleId.map(value => value),
        name.map(value => value),
        price.map(value => value),
        storagePerMonthInGb.map(value => value),
        transferPerMonthInGb.map(value => value),
        isActive.map(value => value)
      )
    def bundleId: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def price: Optional[Float]
    def storagePerMonthInGb: Optional[Integer]
    def transferPerMonthInGb: Optional[Integer]
    def isActive: Optional[Boolean]
    def getBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", price)
    def getStoragePerMonthInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("storagePerMonthInGb", storagePerMonthInGb)
    def getTransferPerMonthInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("transferPerMonthInGb", transferPerMonthInGb)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.BucketBundle
  ) extends zio.aws.lightsail.model.BucketBundle.ReadOnly {
    override val bundleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val price: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.price())
      .map(value => value: Float)
    override val storagePerMonthInGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.storagePerMonthInGb())
      .map(value => value: Integer)
    override val transferPerMonthInGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.transferPerMonthInGb())
      .map(value => value: Integer)
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.BucketBundle
  ): zio.aws.lightsail.model.BucketBundle.ReadOnly = new Wrapper(impl)
}
