package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Bundle(
    price: Optional[Float] = Optional.Absent,
    cpuCount: Optional[Integer] = Optional.Absent,
    diskSizeInGb: Optional[Integer] = Optional.Absent,
    bundleId: Optional[NonEmptyString] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    isActive: Optional[Boolean] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    power: Optional[Integer] = Optional.Absent,
    ramSizeInGb: Optional[Float] = Optional.Absent,
    transferPerMonthInGb: Optional[Integer] = Optional.Absent,
    supportedPlatforms: Optional[
      Iterable[zio.aws.lightsail.model.InstancePlatform]
    ] = Optional.Absent,
    supportedAppCategories: Optional[
      Iterable[zio.aws.lightsail.model.AppCategory]
    ] = Optional.Absent,
    publicIpv4AddressCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Bundle = {
    import Bundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Bundle
      .builder()
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(cpuCount.map(value => value: java.lang.Integer))(
        _.cpuCount
      )
      .optionallyWith(diskSizeInGb.map(value => value: java.lang.Integer))(
        _.diskSizeInGb
      )
      .optionallyWith(
        bundleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(power.map(value => value: java.lang.Integer))(_.power)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .optionallyWith(
        transferPerMonthInGb.map(value => value: java.lang.Integer)
      )(_.transferPerMonthInGb)
      .optionallyWith(
        supportedPlatforms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedPlatformsWithStrings)
      .optionallyWith(
        supportedAppCategories.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedAppCategoriesWithStrings)
      .optionallyWith(
        publicIpv4AddressCount.map(value => value: java.lang.Integer)
      )(_.publicIpv4AddressCount)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Bundle.ReadOnly =
    zio.aws.lightsail.model.Bundle.wrap(buildAwsValue())
}
object Bundle {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Bundle] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Bundle =
      zio.aws.lightsail.model.Bundle(
        price.map(value => value),
        cpuCount.map(value => value),
        diskSizeInGb.map(value => value),
        bundleId.map(value => value),
        instanceType.map(value => value),
        isActive.map(value => value),
        name.map(value => value),
        power.map(value => value),
        ramSizeInGb.map(value => value),
        transferPerMonthInGb.map(value => value),
        supportedPlatforms.map(value => value),
        supportedAppCategories.map(value => value),
        publicIpv4AddressCount.map(value => value)
      )
    def price: Optional[Float]
    def cpuCount: Optional[Integer]
    def diskSizeInGb: Optional[Integer]
    def bundleId: Optional[NonEmptyString]
    def instanceType: Optional[String]
    def isActive: Optional[Boolean]
    def name: Optional[String]
    def power: Optional[Integer]
    def ramSizeInGb: Optional[Float]
    def transferPerMonthInGb: Optional[Integer]
    def supportedPlatforms
        : Optional[List[zio.aws.lightsail.model.InstancePlatform]]
    def supportedAppCategories
        : Optional[List[zio.aws.lightsail.model.AppCategory]]
    def publicIpv4AddressCount: Optional[Integer]
    def getPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", price)
    def getCpuCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpuCount", cpuCount)
    def getDiskSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGb)
    def getBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPower: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("power", power)
    def getRamSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGb)
    def getTransferPerMonthInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("transferPerMonthInGb", transferPerMonthInGb)
    def getSupportedPlatforms
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.InstancePlatform]] =
      AwsError.unwrapOptionField("supportedPlatforms", supportedPlatforms)
    def getSupportedAppCategories
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.AppCategory]] =
      AwsError.unwrapOptionField(
        "supportedAppCategories",
        supportedAppCategories
      )
    def getPublicIpv4AddressCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("publicIpv4AddressCount", publicIpv4AddressCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Bundle
  ) extends zio.aws.lightsail.model.Bundle.ReadOnly {
    override val price: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.price())
      .map(value => value: Float)
    override val cpuCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cpuCount())
      .map(value => value: Integer)
    override val diskSizeInGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.diskSizeInGb())
      .map(value => value: Integer)
    override val bundleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val power: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.power())
      .map(value => value: Integer)
    override val ramSizeInGb: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.ramSizeInGb())
      .map(value => value: Float)
    override val transferPerMonthInGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.transferPerMonthInGb())
      .map(value => value: Integer)
    override val supportedPlatforms
        : Optional[List[zio.aws.lightsail.model.InstancePlatform]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedPlatforms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.InstancePlatform.wrap(item)
          }.toList
        )
    override val supportedAppCategories
        : Optional[List[zio.aws.lightsail.model.AppCategory]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedAppCategories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AppCategory.wrap(item)
          }.toList
        )
    override val publicIpv4AddressCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicIpv4AddressCount())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Bundle
  ): zio.aws.lightsail.model.Bundle.ReadOnly = new Wrapper(impl)
}
