package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait CertificateProvider {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.CertificateProvider
}
object CertificateProvider {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.CertificateProvider
  ): zio.aws.lightsail.model.CertificateProvider = value match {
    case software.amazon.awssdk.services.lightsail.model.CertificateProvider.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateProvider.LETS_ENCRYPT =>
      val r = LetsEncrypt
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.CertificateProvider {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.CertificateProvider =
      software.amazon.awssdk.services.lightsail.model.CertificateProvider.UNKNOWN_TO_SDK_VERSION
  }
  case object LetsEncrypt extends zio.aws.lightsail.model.CertificateProvider {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.CertificateProvider =
      software.amazon.awssdk.services.lightsail.model.CertificateProvider.LETS_ENCRYPT
  }
}
