package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  ResourceName,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class ContactMethod(
    contactEndpoint: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[zio.aws.lightsail.model.ContactMethodStatus] =
      Optional.Absent,
    protocol: Optional[zio.aws.lightsail.model.ContactProtocol] =
      Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    supportCode: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContactMethod = {
    import ContactMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContactMethod
      .builder()
      .optionallyWith(
        contactEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.contactEndpoint)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContactMethod.ReadOnly =
    zio.aws.lightsail.model.ContactMethod.wrap(buildAwsValue())
}
object ContactMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContactMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContactMethod =
      zio.aws.lightsail.model.ContactMethod(
        contactEndpoint.map(value => value),
        status.map(value => value),
        protocol.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        supportCode.map(value => value)
      )
    def contactEndpoint: Optional[NonEmptyString]
    def status: Optional[zio.aws.lightsail.model.ContactMethodStatus]
    def protocol: Optional[zio.aws.lightsail.model.ContactProtocol]
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def supportCode: Optional[String]
    def getContactEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("contactEndpoint", contactEndpoint)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ContactMethodStatus] =
      AwsError.unwrapOptionField("status", status)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ContactProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContactMethod
  ) extends zio.aws.lightsail.model.ContactMethod.ReadOnly {
    override val contactEndpoint: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactEndpoint())
        .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val status: Optional[zio.aws.lightsail.model.ContactMethodStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lightsail.model.ContactMethodStatus.wrap(value))
    override val protocol: Optional[zio.aws.lightsail.model.ContactProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.lightsail.model.ContactProtocol.wrap(value))
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContactMethod
  ): zio.aws.lightsail.model.ContactMethod.ReadOnly = new Wrapper(impl)
}
