package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerServiceECRImagePullerRole(
    isActive: Optional[Boolean] = Optional.Absent,
    principalArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRole = {
    import ContainerServiceECRImagePullerRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRole
      .builder()
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .optionallyWith(principalArn.map(value => value: java.lang.String))(
        _.principalArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.ContainerServiceECRImagePullerRole.ReadOnly =
    zio.aws.lightsail.model.ContainerServiceECRImagePullerRole
      .wrap(buildAwsValue())
}
object ContainerServiceECRImagePullerRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServiceECRImagePullerRole =
      zio.aws.lightsail.model.ContainerServiceECRImagePullerRole(
        isActive.map(value => value),
        principalArn.map(value => value)
      )
    def isActive: Optional[Boolean]
    def principalArn: Optional[String]
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
    def getPrincipalArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalArn", principalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRole
  ) extends zio.aws.lightsail.model.ContainerServiceECRImagePullerRole.ReadOnly {
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
    override val principalArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principalArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceECRImagePullerRole
  ): zio.aws.lightsail.model.ContainerServiceECRImagePullerRole.ReadOnly =
    new Wrapper(impl)
}
