package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerServicePower(
    powerId: Optional[String] = Optional.Absent,
    price: Optional[Float] = Optional.Absent,
    cpuCount: Optional[Float] = Optional.Absent,
    ramSizeInGb: Optional[Float] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    isActive: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServicePower = {
    import ContainerServicePower.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServicePower
      .builder()
      .optionallyWith(powerId.map(value => value: java.lang.String))(_.powerId)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(cpuCount.map(value => value: java.lang.Float))(_.cpuCount)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ContainerServicePower.ReadOnly =
    zio.aws.lightsail.model.ContainerServicePower.wrap(buildAwsValue())
}
object ContainerServicePower {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServicePower
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ContainerServicePower =
      zio.aws.lightsail.model.ContainerServicePower(
        powerId.map(value => value),
        price.map(value => value),
        cpuCount.map(value => value),
        ramSizeInGb.map(value => value),
        name.map(value => value),
        isActive.map(value => value)
      )
    def powerId: Optional[String]
    def price: Optional[Float]
    def cpuCount: Optional[Float]
    def ramSizeInGb: Optional[Float]
    def name: Optional[String]
    def isActive: Optional[Boolean]
    def getPowerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("powerId", powerId)
    def getPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", price)
    def getCpuCount: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("cpuCount", cpuCount)
    def getRamSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGb)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServicePower
  ) extends zio.aws.lightsail.model.ContainerServicePower.ReadOnly {
    override val powerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.powerId())
      .map(value => value: String)
    override val price: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.price())
      .map(value => value: Float)
    override val cpuCount: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.cpuCount())
      .map(value => value: Float)
    override val ramSizeInGb: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.ramSizeInGb())
      .map(value => value: Float)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val isActive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isActive())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServicePower
  ): zio.aws.lightsail.model.ContainerServicePower.ReadOnly = new Wrapper(impl)
}
