package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait ContainerServiceState {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceState
}
object ContainerServiceState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ContainerServiceState
  ): zio.aws.lightsail.model.ContainerServiceState = value match {
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DEPLOYING =>
      val r = DEPLOYING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.ContainerServiceState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceState =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.lightsail.model.ContainerServiceState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceState =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceState.PENDING
  }
  case object READY extends zio.aws.lightsail.model.ContainerServiceState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceState =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceState.READY
  }
  case object RUNNING extends zio.aws.lightsail.model.ContainerServiceState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceState =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceState.RUNNING
  }
  case object UPDATING extends zio.aws.lightsail.model.ContainerServiceState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceState =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceState.UPDATING
  }
  case object DELETING extends zio.aws.lightsail.model.ContainerServiceState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceState =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DELETING
  }
  case object DISABLED extends zio.aws.lightsail.model.ContainerServiceState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceState =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DISABLED
  }
  case object DEPLOYING extends zio.aws.lightsail.model.ContainerServiceState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceState =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceState.DEPLOYING
  }
}
