package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CostEstimate(
    usageType: Optional[NonEmptyString] = Optional.Absent,
    resultsByTime: Optional[Iterable[zio.aws.lightsail.model.EstimateByTime]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CostEstimate = {
    import CostEstimate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CostEstimate
      .builder()
      .optionallyWith(
        usageType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.usageType)
      .optionallyWith(
        resultsByTime.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resultsByTime)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CostEstimate.ReadOnly =
    zio.aws.lightsail.model.CostEstimate.wrap(buildAwsValue())
}
object CostEstimate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CostEstimate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CostEstimate =
      zio.aws.lightsail.model.CostEstimate(
        usageType.map(value => value),
        resultsByTime.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def usageType: Optional[NonEmptyString]
    def resultsByTime
        : Optional[List[zio.aws.lightsail.model.EstimateByTime.ReadOnly]]
    def getUsageType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("usageType", usageType)
    def getResultsByTime: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.EstimateByTime.ReadOnly
    ]] = AwsError.unwrapOptionField("resultsByTime", resultsByTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CostEstimate
  ) extends zio.aws.lightsail.model.CostEstimate.ReadOnly {
    override val usageType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.usageType())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val resultsByTime
        : Optional[List[zio.aws.lightsail.model.EstimateByTime.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultsByTime())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.EstimateByTime.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CostEstimate
  ): zio.aws.lightsail.model.CostEstimate.ReadOnly = new Wrapper(impl)
}
