package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.BucketName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateBucketAccessKeyRequest(bucketName: BucketName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest = {
    import CreateBucketAccessKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateBucketAccessKeyRequest.ReadOnly =
    zio.aws.lightsail.model.CreateBucketAccessKeyRequest.wrap(buildAwsValue())
}
object CreateBucketAccessKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateBucketAccessKeyRequest =
      zio.aws.lightsail.model.CreateBucketAccessKeyRequest(bucketName)
    def bucketName: BucketName
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest
  ) extends zio.aws.lightsail.model.CreateBucketAccessKeyRequest.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.lightsail.model.primitives.BucketName(impl.bucketName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest
  ): zio.aws.lightsail.model.CreateBucketAccessKeyRequest.ReadOnly =
    new Wrapper(impl)
}
