package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  Integer,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDiskFromSnapshotRequest(
    diskName: ResourceName,
    diskSnapshotName: Optional[ResourceName] = Optional.Absent,
    availabilityZone: NonEmptyString,
    sizeInGb: Integer,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    addOns: Optional[Iterable[zio.aws.lightsail.model.AddOnRequest]] =
      Optional.Absent,
    sourceDiskName: Optional[String] = Optional.Absent,
    restoreDate: Optional[String] = Optional.Absent,
    useLatestRestorableAutoSnapshot: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest = {
    import CreateDiskFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
      .builder()
      .diskName(ResourceName.unwrap(diskName): java.lang.String)
      .optionallyWith(
        diskSnapshotName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.diskSnapshotName)
      .availabilityZone(
        NonEmptyString.unwrap(availabilityZone): java.lang.String
      )
      .sizeInGb(sizeInGb: java.lang.Integer)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(sourceDiskName.map(value => value: java.lang.String))(
        _.sourceDiskName
      )
      .optionallyWith(restoreDate.map(value => value: java.lang.String))(
        _.restoreDate
      )
      .optionallyWith(
        useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableAutoSnapshot)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateDiskFromSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.CreateDiskFromSnapshotRequest.wrap(buildAwsValue())
}
object CreateDiskFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDiskFromSnapshotRequest =
      zio.aws.lightsail.model.CreateDiskFromSnapshotRequest(
        diskName,
        diskSnapshotName.map(value => value),
        availabilityZone,
        sizeInGb,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addOns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceDiskName.map(value => value),
        restoreDate.map(value => value),
        useLatestRestorableAutoSnapshot.map(value => value)
      )
    def diskName: ResourceName
    def diskSnapshotName: Optional[ResourceName]
    def availabilityZone: NonEmptyString
    def sizeInGb: Integer
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def addOns: Optional[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]]
    def sourceDiskName: Optional[String]
    def restoreDate: Optional[String]
    def useLatestRestorableAutoSnapshot: Optional[Boolean]
    def getDiskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskName)
    def getDiskSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("diskSnapshotName", diskSnapshotName)
    def getAvailabilityZone: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(availabilityZone)
    def getSizeInGb: ZIO[Any, Nothing, Integer] = ZIO.succeed(sizeInGb)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAddOns: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AddOnRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOns)
    def getSourceDiskName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceDiskName", sourceDiskName)
    def getRestoreDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreDate", restoreDate)
    def getUseLatestRestorableAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useLatestRestorableAutoSnapshot",
        useLatestRestorableAutoSnapshot
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
  ) extends zio.aws.lightsail.model.CreateDiskFromSnapshotRequest.ReadOnly {
    override val diskName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskName())
    override val diskSnapshotName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskSnapshotName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val availabilityZone: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.availabilityZone())
    override val sizeInGb: Integer = impl.sizeInGb(): Integer
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val addOns
        : Optional[List[zio.aws.lightsail.model.AddOnRequest.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addOns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AddOnRequest.wrap(item)
          }.toList
        )
    override val sourceDiskName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDiskName())
      .map(value => value: String)
    override val restoreDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.restoreDate())
      .map(value => value: String)
    override val useLatestRestorableAutoSnapshot: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useLatestRestorableAutoSnapshot())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
  ): zio.aws.lightsail.model.CreateDiskFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
