package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDiskSnapshotRequest(
    diskName: Optional[ResourceName] = Optional.Absent,
    diskSnapshotName: ResourceName,
    instanceName: Optional[ResourceName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest = {
    import CreateDiskSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest
      .builder()
      .optionallyWith(
        diskName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.diskName)
      .diskSnapshotName(ResourceName.unwrap(diskSnapshotName): java.lang.String)
      .optionallyWith(
        instanceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.instanceName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateDiskSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.CreateDiskSnapshotRequest.wrap(buildAwsValue())
}
object CreateDiskSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDiskSnapshotRequest =
      zio.aws.lightsail.model.CreateDiskSnapshotRequest(
        diskName.map(value => value),
        diskSnapshotName,
        instanceName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def diskName: Optional[ResourceName]
    def diskSnapshotName: ResourceName
    def instanceName: Optional[ResourceName]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getDiskName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("diskName", diskName)
    def getDiskSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(diskSnapshotName)
    def getInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest
  ) extends zio.aws.lightsail.model.CreateDiskSnapshotRequest.ReadOnly {
    override val diskName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.diskName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val diskSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.diskSnapshotName())
    override val instanceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest
  ): zio.aws.lightsail.model.CreateDiskSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
