package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDomainEntryResponse(
    operation: Optional[zio.aws.lightsail.model.Operation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse = {
    import CreateDomainEntryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateDomainEntryResponse.ReadOnly =
    zio.aws.lightsail.model.CreateDomainEntryResponse.wrap(buildAwsValue())
}
object CreateDomainEntryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateDomainEntryResponse =
      zio.aws.lightsail.model
        .CreateDomainEntryResponse(operation.map(value => value.asEditable))
    def operation: Optional[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse
  ) extends zio.aws.lightsail.model.CreateDomainEntryResponse.ReadOnly {
    override val operation
        : Optional[zio.aws.lightsail.model.Operation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse
  ): zio.aws.lightsail.model.CreateDomainEntryResponse.ReadOnly = new Wrapper(
    impl
  )
}
