package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateGuiSessionAccessDetailsRequest(
    resourceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsRequest = {
    import CreateGuiSessionAccessDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateGuiSessionAccessDetailsRequest.ReadOnly =
    zio.aws.lightsail.model.CreateGuiSessionAccessDetailsRequest
      .wrap(buildAwsValue())
}
object CreateGuiSessionAccessDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CreateGuiSessionAccessDetailsRequest =
      zio.aws.lightsail.model.CreateGuiSessionAccessDetailsRequest(resourceName)
    def resourceName: ResourceName
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsRequest
  ) extends zio.aws.lightsail.model.CreateGuiSessionAccessDetailsRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsRequest
  ): zio.aws.lightsail.model.CreateGuiSessionAccessDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
