package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Integer, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGuiSessionAccessDetailsResponse(
    resourceName: Optional[ResourceName] = Optional.Absent,
    status: Optional[zio.aws.lightsail.model.Status] = Optional.Absent,
    percentageComplete: Optional[Integer] = Optional.Absent,
    failureReason: Optional[String] = Optional.Absent,
    sessions: Optional[Iterable[zio.aws.lightsail.model.Session]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsResponse = {
    import CreateGuiSessionAccessDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsResponse
      .builder()
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        percentageComplete.map(value => value: java.lang.Integer)
      )(_.percentageComplete)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .optionallyWith(
        sessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sessions)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse.ReadOnly =
    zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse
      .wrap(buildAwsValue())
}
object CreateGuiSessionAccessDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse =
      zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse(
        resourceName.map(value => value),
        status.map(value => value),
        percentageComplete.map(value => value),
        failureReason.map(value => value),
        sessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceName: Optional[ResourceName]
    def status: Optional[zio.aws.lightsail.model.Status]
    def percentageComplete: Optional[Integer]
    def failureReason: Optional[String]
    def sessions: Optional[List[zio.aws.lightsail.model.Session.ReadOnly]]
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getStatus: ZIO[Any, AwsError, zio.aws.lightsail.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getPercentageComplete: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentageComplete", percentageComplete)
    def getFailureReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getSessions
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Session.ReadOnly]] =
      AwsError.unwrapOptionField("sessions", sessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsResponse
  ) extends zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse.ReadOnly {
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val status: Optional[zio.aws.lightsail.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.lightsail.model.Status.wrap(value))
    override val percentageComplete: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.percentageComplete())
      .map(value => value: Integer)
    override val failureReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: String)
    override val sessions
        : Optional[List[zio.aws.lightsail.model.Session.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Session.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateGuiSessionAccessDetailsResponse
  ): zio.aws.lightsail.model.CreateGuiSessionAccessDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
