package zio.aws.lightsail.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{DomainName, Port, ResourceName}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateLoadBalancerRequest(
    loadBalancerName: ResourceName,
    instancePort: Port,
    healthCheckPath: Optional[String] = Optional.Absent,
    certificateName: Optional[ResourceName] = Optional.Absent,
    certificateDomainName: Optional[DomainName] = Optional.Absent,
    certificateAlternativeNames: Optional[Iterable[DomainName]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType] =
      Optional.Absent,
    tlsPolicyName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest = {
    import CreateLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest
      .builder()
      .loadBalancerName(ResourceName.unwrap(loadBalancerName): java.lang.String)
      .instancePort(Port.unwrap(instancePort): Integer)
      .optionallyWith(healthCheckPath.map(value => value: java.lang.String))(
        _.healthCheckPath
      )
      .optionallyWith(
        certificateName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .optionallyWith(
        certificateDomainName.map(value =>
          DomainName.unwrap(value): java.lang.String
        )
      )(_.certificateDomainName)
      .optionallyWith(
        certificateAlternativeNames.map(value =>
          value.map { item =>
            DomainName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.certificateAlternativeNames)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(tlsPolicyName.map(value => value: java.lang.String))(
        _.tlsPolicyName
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.CreateLoadBalancerRequest.ReadOnly =
    zio.aws.lightsail.model.CreateLoadBalancerRequest.wrap(buildAwsValue())
}
object CreateLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.CreateLoadBalancerRequest =
      zio.aws.lightsail.model.CreateLoadBalancerRequest(
        loadBalancerName,
        instancePort,
        healthCheckPath.map(value => value),
        certificateName.map(value => value),
        certificateDomainName.map(value => value),
        certificateAlternativeNames.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipAddressType.map(value => value),
        tlsPolicyName.map(value => value)
      )
    def loadBalancerName: ResourceName
    def instancePort: Port
    def healthCheckPath: Optional[String]
    def certificateName: Optional[ResourceName]
    def certificateDomainName: Optional[DomainName]
    def certificateAlternativeNames: Optional[List[DomainName]]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def ipAddressType: Optional[zio.aws.lightsail.model.IpAddressType]
    def tlsPolicyName: Optional[String]
    def getLoadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerName)
    def getInstancePort: ZIO[Any, Nothing, Port] = ZIO.succeed(instancePort)
    def getHealthCheckPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("healthCheckPath", healthCheckPath)
    def getCertificateName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getCertificateDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("certificateDomainName", certificateDomainName)
    def getCertificateAlternativeNames: ZIO[Any, AwsError, List[DomainName]] =
      AwsError.unwrapOptionField(
        "certificateAlternativeNames",
        certificateAlternativeNames
      )
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getTlsPolicyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tlsPolicyName", tlsPolicyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest
  ) extends zio.aws.lightsail.model.CreateLoadBalancerRequest.ReadOnly {
    override val loadBalancerName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.loadBalancerName())
    override val instancePort: Port =
      zio.aws.lightsail.model.primitives.Port(impl.instancePort())
    override val healthCheckPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.healthCheckPath())
      .map(value => value: String)
    override val certificateName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val certificateDomainName: Optional[DomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateDomainName())
        .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val certificateAlternativeNames: Optional[List[DomainName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateAlternativeNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.primitives.DomainName(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val ipAddressType
        : Optional[zio.aws.lightsail.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
    override val tlsPolicyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tlsPolicyName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest
  ): zio.aws.lightsail.model.CreateLoadBalancerRequest.ReadOnly = new Wrapper(
    impl
  )
}
