package zio.aws.lightsail.model
import scala.jdk.CollectionConverters._
sealed trait Currency {
  def unwrap: software.amazon.awssdk.services.lightsail.model.Currency
}
object Currency {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.Currency
  ): zio.aws.lightsail.model.Currency = value match {
    case software.amazon.awssdk.services.lightsail.model.Currency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.Currency.USD =>
      val r = USD
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.Currency {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Currency =
      software.amazon.awssdk.services.lightsail.model.Currency.UNKNOWN_TO_SDK_VERSION
  }
  case object USD extends zio.aws.lightsail.model.Currency {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.Currency =
      software.amazon.awssdk.services.lightsail.model.Currency.USD
  }
}
