package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.BucketName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteBucketRequest(
    bucketName: BucketName,
    forceDelete: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest = {
    import DeleteBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteBucketRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteBucketRequest.wrap(buildAwsValue())
}
object DeleteBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteBucketRequest =
      zio.aws.lightsail.model
        .DeleteBucketRequest(bucketName, forceDelete.map(value => value))
    def bucketName: BucketName
    def forceDelete: Optional[Boolean]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getForceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest
  ) extends zio.aws.lightsail.model.DeleteBucketRequest.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.lightsail.model.primitives.BucketName(impl.bucketName())
    override val forceDelete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDelete())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest
  ): zio.aws.lightsail.model.DeleteBucketRequest.ReadOnly = new Wrapper(impl)
}
