package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDistributionRequest(
    distributionName: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest = {
    import DeleteDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest
      .builder()
      .optionallyWith(
        distributionName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.distributionName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DeleteDistributionRequest.ReadOnly =
    zio.aws.lightsail.model.DeleteDistributionRequest.wrap(buildAwsValue())
}
object DeleteDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DeleteDistributionRequest =
      zio.aws.lightsail.model
        .DeleteDistributionRequest(distributionName.map(value => value))
    def distributionName: Optional[ResourceName]
    def getDistributionName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("distributionName", distributionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest
  ) extends zio.aws.lightsail.model.DeleteDistributionRequest.ReadOnly {
    override val distributionName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionName())
        .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest
  ): zio.aws.lightsail.model.DeleteDistributionRequest.ReadOnly = new Wrapper(
    impl
  )
}
