package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  Integer,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class Disk(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    addOns: Optional[Iterable[zio.aws.lightsail.model.AddOn]] = Optional.Absent,
    sizeInGb: Optional[Integer] = Optional.Absent,
    isSystemDisk: Optional[Boolean] = Optional.Absent,
    iops: Optional[Integer] = Optional.Absent,
    path: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.lightsail.model.DiskState] = Optional.Absent,
    attachedTo: Optional[ResourceName] = Optional.Absent,
    isAttached: Optional[Boolean] = Optional.Absent,
    attachmentState: Optional[String] = Optional.Absent,
    gbInUse: Optional[Integer] = Optional.Absent,
    autoMountStatus: Optional[zio.aws.lightsail.model.AutoMountStatus] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Disk = {
    import Disk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Disk
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .optionallyWith(isSystemDisk.map(value => value: java.lang.Boolean))(
        _.isSystemDisk
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        attachedTo.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.attachedTo)
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .optionallyWith(attachmentState.map(value => value: java.lang.String))(
        _.attachmentState
      )
      .optionallyWith(gbInUse.map(value => value: java.lang.Integer))(_.gbInUse)
      .optionallyWith(autoMountStatus.map(value => value.unwrap))(
        _.autoMountStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Disk.ReadOnly =
    zio.aws.lightsail.model.Disk.wrap(buildAwsValue())
}
object Disk {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Disk] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Disk = zio.aws.lightsail.model.Disk(
      name.map(value => value),
      arn.map(value => value),
      supportCode.map(value => value),
      createdAt.map(value => value),
      location.map(value => value.asEditable),
      resourceType.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      addOns.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      sizeInGb.map(value => value),
      isSystemDisk.map(value => value),
      iops.map(value => value),
      path.map(value => value),
      state.map(value => value),
      attachedTo.map(value => value),
      isAttached.map(value => value),
      attachmentState.map(value => value),
      gbInUse.map(value => value),
      autoMountStatus.map(value => value)
    )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def addOns: Optional[List[zio.aws.lightsail.model.AddOn.ReadOnly]]
    def sizeInGb: Optional[Integer]
    def isSystemDisk: Optional[Boolean]
    def iops: Optional[Integer]
    def path: Optional[String]
    def state: Optional[zio.aws.lightsail.model.DiskState]
    def attachedTo: Optional[ResourceName]
    def isAttached: Optional[Boolean]
    def attachmentState: Optional[String]
    def gbInUse: Optional[Integer]
    def autoMountStatus: Optional[zio.aws.lightsail.model.AutoMountStatus]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAddOns
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.AddOn.ReadOnly]] =
      AwsError.unwrapOptionField("addOns", addOns)
    def getSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGb)
    def getIsSystemDisk: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSystemDisk", isSystemDisk)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getState: ZIO[Any, AwsError, zio.aws.lightsail.model.DiskState] =
      AwsError.unwrapOptionField("state", state)
    def getAttachedTo: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("attachedTo", attachedTo)
    def getIsAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttached)
    def getAttachmentState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentState", attachmentState)
    def getGbInUse: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("gbInUse", gbInUse)
    def getAutoMountStatus
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AutoMountStatus] =
      AwsError.unwrapOptionField("autoMountStatus", autoMountStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Disk
  ) extends zio.aws.lightsail.model.Disk.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val addOns
        : Optional[List[zio.aws.lightsail.model.AddOn.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addOns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AddOn.wrap(item)
          }.toList
        )
    override val sizeInGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInGb())
      .map(value => value: Integer)
    override val isSystemDisk: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSystemDisk())
      .map(value => value: Boolean)
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val state: Optional[zio.aws.lightsail.model.DiskState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.lightsail.model.DiskState.wrap(value))
    override val attachedTo: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedTo())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val isAttached: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isAttached())
      .map(value => value: Boolean)
    override val attachmentState: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentState())
      .map(value => value: String)
    override val gbInUse: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.gbInUse())
      .map(value => value: Integer)
    override val autoMountStatus
        : Optional[zio.aws.lightsail.model.AutoMountStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMountStatus())
        .map(value => zio.aws.lightsail.model.AutoMountStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Disk
  ): zio.aws.lightsail.model.Disk.ReadOnly = new Wrapper(impl)
}
