package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DnsRecordCreationState(
    code: Optional[zio.aws.lightsail.model.DnsRecordCreationStateCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DnsRecordCreationState = {
    import DnsRecordCreationState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DnsRecordCreationState
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DnsRecordCreationState.ReadOnly =
    zio.aws.lightsail.model.DnsRecordCreationState.wrap(buildAwsValue())
}
object DnsRecordCreationState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DnsRecordCreationState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DnsRecordCreationState =
      zio.aws.lightsail.model.DnsRecordCreationState(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.lightsail.model.DnsRecordCreationStateCode]
    def message: Optional[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.DnsRecordCreationStateCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DnsRecordCreationState
  ) extends zio.aws.lightsail.model.DnsRecordCreationState.ReadOnly {
    override val code
        : Optional[zio.aws.lightsail.model.DnsRecordCreationStateCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.lightsail.model.DnsRecordCreationStateCode.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DnsRecordCreationState
  ): zio.aws.lightsail.model.DnsRecordCreationState.ReadOnly = new Wrapper(impl)
}
