package zio.aws.lightsail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class Domain(
    name: Optional[ResourceName] = Optional.Absent,
    arn: Optional[NonEmptyString] = Optional.Absent,
    supportCode: Optional[String] = Optional.Absent,
    createdAt: Optional[IsoDate] = Optional.Absent,
    location: Optional[zio.aws.lightsail.model.ResourceLocation] =
      Optional.Absent,
    resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.lightsail.model.Tag]] = Optional.Absent,
    domainEntries: Optional[Iterable[zio.aws.lightsail.model.DomainEntry]] =
      Optional.Absent,
    registeredDomainDelegationInfo: Optional[
      zio.aws.lightsail.model.RegisteredDomainDelegationInfo
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Domain = {
    import Domain.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Domain
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        domainEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainEntries)
      .optionallyWith(
        registeredDomainDelegationInfo.map(value => value.buildAwsValue())
      )(_.registeredDomainDelegationInfo)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Domain.ReadOnly =
    zio.aws.lightsail.model.Domain.wrap(buildAwsValue())
}
object Domain {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Domain] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Domain =
      zio.aws.lightsail.model.Domain(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        domainEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        registeredDomainDelegationInfo.map(value => value.asEditable)
      )
    def name: Optional[ResourceName]
    def arn: Optional[NonEmptyString]
    def supportCode: Optional[String]
    def createdAt: Optional[IsoDate]
    def location: Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Optional[zio.aws.lightsail.model.ResourceType]
    def tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def domainEntries
        : Optional[List[zio.aws.lightsail.model.DomainEntry.ReadOnly]]
    def registeredDomainDelegationInfo: Optional[
      zio.aws.lightsail.model.RegisteredDomainDelegationInfo.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDomainEntries: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.DomainEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("domainEntries", domainEntries)
    def getRegisteredDomainDelegationInfo: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.RegisteredDomainDelegationInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "registeredDomainDelegationInfo",
      registeredDomainDelegationInfo
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Domain
  ) extends zio.aws.lightsail.model.Domain.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportCode())
      .map(value => value: String)
    override val createdAt: Optional[IsoDate] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Optional[zio.aws.lightsail.model.ResourceLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Optional[zio.aws.lightsail.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Optional[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val domainEntries
        : Optional[List[zio.aws.lightsail.model.DomainEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainEntries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.DomainEntry.wrap(item)
          }.toList
        )
    override val registeredDomainDelegationInfo: Optional[
      zio.aws.lightsail.model.RegisteredDomainDelegationInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredDomainDelegationInfo())
      .map(value =>
        zio.aws.lightsail.model.RegisteredDomainDelegationInfo.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Domain
  ): zio.aws.lightsail.model.Domain.ReadOnly = new Wrapper(impl)
}
