package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DomainValidationRecord(
    domainName: Optional[DomainName] = Optional.Absent,
    resourceRecord: Optional[zio.aws.lightsail.model.ResourceRecord] =
      Optional.Absent,
    dnsRecordCreationState: Optional[
      zio.aws.lightsail.model.DnsRecordCreationState
    ] = Optional.Absent,
    validationStatus: Optional[
      zio.aws.lightsail.model.CertificateDomainValidationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DomainValidationRecord = {
    import DomainValidationRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(resourceRecord.map(value => value.buildAwsValue()))(
        _.resourceRecord
      )
      .optionallyWith(
        dnsRecordCreationState.map(value => value.buildAwsValue())
      )(_.dnsRecordCreationState)
      .optionallyWith(validationStatus.map(value => value.unwrap))(
        _.validationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.DomainValidationRecord.ReadOnly =
    zio.aws.lightsail.model.DomainValidationRecord.wrap(buildAwsValue())
}
object DomainValidationRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.DomainValidationRecord =
      zio.aws.lightsail.model.DomainValidationRecord(
        domainName.map(value => value),
        resourceRecord.map(value => value.asEditable),
        dnsRecordCreationState.map(value => value.asEditable),
        validationStatus.map(value => value)
      )
    def domainName: Optional[DomainName]
    def resourceRecord
        : Optional[zio.aws.lightsail.model.ResourceRecord.ReadOnly]
    def dnsRecordCreationState
        : Optional[zio.aws.lightsail.model.DnsRecordCreationState.ReadOnly]
    def validationStatus
        : Optional[zio.aws.lightsail.model.CertificateDomainValidationStatus]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getResourceRecord
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceRecord.ReadOnly] =
      AwsError.unwrapOptionField("resourceRecord", resourceRecord)
    def getDnsRecordCreationState: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.DnsRecordCreationState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dnsRecordCreationState",
      dnsRecordCreationState
    )
    def getValidationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.CertificateDomainValidationStatus
    ] = AwsError.unwrapOptionField("validationStatus", validationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
  ) extends zio.aws.lightsail.model.DomainValidationRecord.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val resourceRecord
        : Optional[zio.aws.lightsail.model.ResourceRecord.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRecord())
        .map(value => zio.aws.lightsail.model.ResourceRecord.wrap(value))
    override val dnsRecordCreationState
        : Optional[zio.aws.lightsail.model.DnsRecordCreationState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsRecordCreationState())
        .map(value =>
          zio.aws.lightsail.model.DnsRecordCreationState.wrap(value)
        )
    override val validationStatus
        : Optional[zio.aws.lightsail.model.CertificateDomainValidationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationStatus())
        .map(value =>
          zio.aws.lightsail.model.CertificateDomainValidationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DomainValidationRecord
  ): zio.aws.lightsail.model.DomainValidationRecord.ReadOnly = new Wrapper(impl)
}
