package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EstimateByTime(
    usageCost: Optional[Double] = Optional.Absent,
    pricingUnit: Optional[zio.aws.lightsail.model.PricingUnit] =
      Optional.Absent,
    unit: Optional[Double] = Optional.Absent,
    currency: Optional[zio.aws.lightsail.model.Currency] = Optional.Absent,
    timePeriod: Optional[zio.aws.lightsail.model.TimePeriod] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.EstimateByTime = {
    import EstimateByTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.EstimateByTime
      .builder()
      .optionallyWith(usageCost.map(value => value: java.lang.Double))(
        _.usageCost
      )
      .optionallyWith(pricingUnit.map(value => value.unwrap))(_.pricingUnit)
      .optionallyWith(unit.map(value => value: java.lang.Double))(_.unit)
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(timePeriod.map(value => value.buildAwsValue()))(
        _.timePeriod
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.EstimateByTime.ReadOnly =
    zio.aws.lightsail.model.EstimateByTime.wrap(buildAwsValue())
}
object EstimateByTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.EstimateByTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.EstimateByTime =
      zio.aws.lightsail.model.EstimateByTime(
        usageCost.map(value => value),
        pricingUnit.map(value => value),
        unit.map(value => value),
        currency.map(value => value),
        timePeriod.map(value => value.asEditable)
      )
    def usageCost: Optional[Double]
    def pricingUnit: Optional[zio.aws.lightsail.model.PricingUnit]
    def unit: Optional[Double]
    def currency: Optional[zio.aws.lightsail.model.Currency]
    def timePeriod: Optional[zio.aws.lightsail.model.TimePeriod.ReadOnly]
    def getUsageCost: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usageCost", usageCost)
    def getPricingUnit
        : ZIO[Any, AwsError, zio.aws.lightsail.model.PricingUnit] =
      AwsError.unwrapOptionField("pricingUnit", pricingUnit)
    def getUnit: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("unit", unit)
    def getCurrency: ZIO[Any, AwsError, zio.aws.lightsail.model.Currency] =
      AwsError.unwrapOptionField("currency", currency)
    def getTimePeriod
        : ZIO[Any, AwsError, zio.aws.lightsail.model.TimePeriod.ReadOnly] =
      AwsError.unwrapOptionField("timePeriod", timePeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.EstimateByTime
  ) extends zio.aws.lightsail.model.EstimateByTime.ReadOnly {
    override val usageCost: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.usageCost())
      .map(value => value: Double)
    override val pricingUnit: Optional[zio.aws.lightsail.model.PricingUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingUnit())
        .map(value => zio.aws.lightsail.model.PricingUnit.wrap(value))
    override val unit: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => value: Double)
    override val currency: Optional[zio.aws.lightsail.model.Currency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currency())
        .map(value => zio.aws.lightsail.model.Currency.wrap(value))
    override val timePeriod
        : Optional[zio.aws.lightsail.model.TimePeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timePeriod())
        .map(value => zio.aws.lightsail.model.TimePeriod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.EstimateByTime
  ): zio.aws.lightsail.model.EstimateByTime.ReadOnly = new Wrapper(impl)
}
