package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBundlesRequest(
    includeInactive: Optional[Boolean] = Optional.Absent,
    pageToken: Optional[String] = Optional.Absent,
    appCategory: Optional[zio.aws.lightsail.model.AppCategory] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBundlesRequest = {
    import GetBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
      .builder()
      .optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(
        _.includeInactive
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .optionallyWith(appCategory.map(value => value.unwrap))(_.appCategory)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetBundlesRequest.ReadOnly =
    zio.aws.lightsail.model.GetBundlesRequest.wrap(buildAwsValue())
}
object GetBundlesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetBundlesRequest =
      zio.aws.lightsail.model.GetBundlesRequest(
        includeInactive.map(value => value),
        pageToken.map(value => value),
        appCategory.map(value => value)
      )
    def includeInactive: Optional[Boolean]
    def pageToken: Optional[String]
    def appCategory: Optional[zio.aws.lightsail.model.AppCategory]
    def getIncludeInactive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeInactive", includeInactive)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getAppCategory
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AppCategory] =
      AwsError.unwrapOptionField("appCategory", appCategory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
  ) extends zio.aws.lightsail.model.GetBundlesRequest.ReadOnly {
    override val includeInactive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeInactive())
      .map(value => value: Boolean)
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
    override val appCategory: Optional[zio.aws.lightsail.model.AppCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appCategory())
        .map(value => zio.aws.lightsail.model.AppCategory.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
  ): zio.aws.lightsail.model.GetBundlesRequest.ReadOnly = new Wrapper(impl)
}
