package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  CertificateName,
  IncludeCertificateDetails
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCertificatesRequest(
    certificateStatuses: Optional[
      Iterable[zio.aws.lightsail.model.CertificateStatus]
    ] = Optional.Absent,
    includeCertificateDetails: Optional[IncludeCertificateDetails] =
      Optional.Absent,
    certificateName: Optional[CertificateName] = Optional.Absent,
    pageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest = {
    import GetCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
      .builder()
      .optionallyWith(
        certificateStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.certificateStatusesWithStrings)
      .optionallyWith(
        includeCertificateDetails.map(value =>
          IncludeCertificateDetails.unwrap(value): java.lang.Boolean
        )
      )(_.includeCertificateDetails)
      .optionallyWith(
        certificateName.map(value =>
          CertificateName.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetCertificatesRequest.ReadOnly =
    zio.aws.lightsail.model.GetCertificatesRequest.wrap(buildAwsValue())
}
object GetCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetCertificatesRequest =
      zio.aws.lightsail.model.GetCertificatesRequest(
        certificateStatuses.map(value => value),
        includeCertificateDetails.map(value => value),
        certificateName.map(value => value),
        pageToken.map(value => value)
      )
    def certificateStatuses
        : Optional[List[zio.aws.lightsail.model.CertificateStatus]]
    def includeCertificateDetails: Optional[IncludeCertificateDetails]
    def certificateName: Optional[CertificateName]
    def pageToken: Optional[String]
    def getCertificateStatuses
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.CertificateStatus]] =
      AwsError.unwrapOptionField("certificateStatuses", certificateStatuses)
    def getIncludeCertificateDetails
        : ZIO[Any, AwsError, IncludeCertificateDetails] = AwsError
      .unwrapOptionField("includeCertificateDetails", includeCertificateDetails)
    def getCertificateName: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
  ) extends zio.aws.lightsail.model.GetCertificatesRequest.ReadOnly {
    override val certificateStatuses
        : Optional[List[zio.aws.lightsail.model.CertificateStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.CertificateStatus.wrap(item)
          }.toList
        )
    override val includeCertificateDetails
        : Optional[IncludeCertificateDetails] = zio.aws.core.internal
      .optionalFromNullable(impl.includeCertificateDetails())
      .map(value =>
        zio.aws.lightsail.model.primitives.IncludeCertificateDetails(value)
      )
    override val certificateName: Optional[CertificateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateName())
        .map(value => zio.aws.lightsail.model.primitives.CertificateName(value))
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
  ): zio.aws.lightsail.model.GetCertificatesRequest.ReadOnly = new Wrapper(impl)
}
