package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCertificatesResponse(
    certificates: Optional[
      Iterable[zio.aws.lightsail.model.CertificateSummary]
    ] = Optional.Absent,
    nextPageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse = {
    import GetCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
      .builder()
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly =
    zio.aws.lightsail.model.GetCertificatesResponse.wrap(buildAwsValue())
}
object GetCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetCertificatesResponse =
      zio.aws.lightsail.model.GetCertificatesResponse(
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def certificates
        : Optional[List[zio.aws.lightsail.model.CertificateSummary.ReadOnly]]
    def nextPageToken: Optional[String]
    def getCertificates: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CertificateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificates)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
  ) extends zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly {
    override val certificates
        : Optional[List[zio.aws.lightsail.model.CertificateSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.CertificateSummary.wrap(item)
          }.toList
        )
    override val nextPageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
  ): zio.aws.lightsail.model.GetCertificatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
