package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCloudFormationStackRecordsRequest(
    pageToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest = {
    import GetCloudFormationStackRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetCloudFormationStackRecordsRequest.ReadOnly =
    zio.aws.lightsail.model.GetCloudFormationStackRecordsRequest
      .wrap(buildAwsValue())
}
object GetCloudFormationStackRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetCloudFormationStackRecordsRequest =
      zio.aws.lightsail.model
        .GetCloudFormationStackRecordsRequest(pageToken.map(value => value))
    def pageToken: Optional[String]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest
  ) extends zio.aws.lightsail.model.GetCloudFormationStackRecordsRequest.ReadOnly {
    override val pageToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pageToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest
  ): zio.aws.lightsail.model.GetCloudFormationStackRecordsRequest.ReadOnly =
    new Wrapper(impl)
}
