package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContainerApiMetadataResponse(
    metadata: Optional[Iterable[Map[String, String]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse = {
    import GetContainerApiMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
      .builder()
      .optionallyWith(
        metadata.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (key: java.lang.String) -> (value: java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.metadata)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly =
    zio.aws.lightsail.model.GetContainerApiMetadataResponse
      .wrap(buildAwsValue())
}
object GetContainerApiMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetContainerApiMetadataResponse =
      zio.aws.lightsail.model
        .GetContainerApiMetadataResponse(metadata.map(value => value))
    def metadata: Optional[List[Map[String, String]]]
    def getMetadata: ZIO[Any, AwsError, List[Map[String, String]]] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
  ) extends zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly {
    override val metadata: Optional[List[Map[String, String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                (key: String) -> (value: String)
              })
              .toMap
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
  ): zio.aws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
