package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{IsoDate, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetCostEstimateRequest(
    resourceName: ResourceName,
    startTime: IsoDate,
    endTime: IsoDate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCostEstimateRequest = {
    import GetCostEstimateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCostEstimateRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .startTime(IsoDate.unwrap(startTime): Instant)
      .endTime(IsoDate.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetCostEstimateRequest.ReadOnly =
    zio.aws.lightsail.model.GetCostEstimateRequest.wrap(buildAwsValue())
}
object GetCostEstimateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCostEstimateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetCostEstimateRequest =
      zio.aws.lightsail.model
        .GetCostEstimateRequest(resourceName, startTime, endTime)
    def resourceName: ResourceName
    def startTime: IsoDate
    def endTime: IsoDate
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
    def getStartTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCostEstimateRequest
  ) extends zio.aws.lightsail.model.GetCostEstimateRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
    override val startTime: IsoDate =
      zio.aws.lightsail.model.primitives.IsoDate(impl.startTime())
    override val endTime: IsoDate =
      zio.aws.lightsail.model.primitives.IsoDate(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCostEstimateRequest
  ): zio.aws.lightsail.model.GetCostEstimateRequest.ReadOnly = new Wrapper(impl)
}
