package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCostEstimateResponse(
    resourcesBudgetEstimate: Optional[
      Iterable[zio.aws.lightsail.model.ResourceBudgetEstimate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCostEstimateResponse = {
    import GetCostEstimateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCostEstimateResponse
      .builder()
      .optionallyWith(
        resourcesBudgetEstimate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcesBudgetEstimate)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetCostEstimateResponse.ReadOnly =
    zio.aws.lightsail.model.GetCostEstimateResponse.wrap(buildAwsValue())
}
object GetCostEstimateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCostEstimateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetCostEstimateResponse =
      zio.aws.lightsail.model.GetCostEstimateResponse(
        resourcesBudgetEstimate.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourcesBudgetEstimate: Optional[
      List[zio.aws.lightsail.model.ResourceBudgetEstimate.ReadOnly]
    ]
    def getResourcesBudgetEstimate: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.ResourceBudgetEstimate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourcesBudgetEstimate",
      resourcesBudgetEstimate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCostEstimateResponse
  ) extends zio.aws.lightsail.model.GetCostEstimateResponse.ReadOnly {
    override val resourcesBudgetEstimate: Optional[
      List[zio.aws.lightsail.model.ResourceBudgetEstimate.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcesBudgetEstimate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.ResourceBudgetEstimate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCostEstimateResponse
  ): zio.aws.lightsail.model.GetCostEstimateResponse.ReadOnly = new Wrapper(
    impl
  )
}
